globals [
  last-turtle
  velocity-data
  old-vel
  old-acc
]
turtles-own [
  mark
  vel-data
  acc-data
]

to setup
  clear-all

;; calculates for every other column and every other row
;; and then sets their color to light brown

  ask patches with
    [(floor((pxcor + max-pxcor - floor(2)) mod 2) = 0) or  
    (floor((pycor + max-pycor) mod 2) = 0)] [              
    set pcolor grey - 4                                    
    ]

;; creates x and y axis lines

  ask patches with [ pxcor = 0 ] [                   
    set pcolor brown
  ]
  ask patches with [ pycor = 0 ] [                   
    set pcolor brown
  ]

;; sets the labels for every other line to be half their
;; coordinate values on the axis lines

  ask patches with [ (pxcor = 0) and (floor((pycor + max-pycor) mod 2) = 0) ] [   
    set plabel ( pycor / 2)
  ]
  ask patches with [ (pycor = 0) and (floor((pxcor + max-pxcor) mod 2) = 0) ] [
    set plabel ( pxcor / 2)
  ]

;; Creates a hidden turtle that stands in for the starting line data.
;; This is also important so the graph "starts" at zero  

  create-turtles 1 [
    set color yellow
    set shape "circle"
    setxy 0 0
    hide-turtle
  ]
  
  set last-turtle -1  ;; presets last-turtle variable for use in new-point code

end

;; To make points the user must press the Interact with Graph" button
;; and then click on intersection locations in the view which sprouts a new turtle.
;; Users cannot click on non-intersection locations and may not
;; create a point behind points they've already made.
;; When a new turtle is made, a link is made to the previous turtle
;; and it's x & y data (divided by two) is set as it's mark and
;; velocity and the "rise over run" is calculated as it's acceleration.
;; This data is "set" (so it can be written easily into a file) and then
;; it is written into the output area.
;; Users can also edit points by clicking on previously made turtles and moving
;; them to a new location.

to new-point-check 
  if mouse-down? [
    let active-patch patch mouse-xcor mouse-ycor
    ifelse not any? turtles-on active-patch 
      [new-point]
      [edit-point]
  ]
end

to new-point
  ask patch mouse-xcor mouse-ycor [
    if not any? turtles-here [
      if (floor((pycor + max-pycor) mod 2) = 0) and (floor((pxcor + max-pxcor) mod 2) = 0) [  ;; click must be in intersection point
        if not any? turtles with [ pxcor >= round (mouse-xcor) ] [ 
          if abs(pycor - [pycor] of turtle (last-turtle + 1)) <= 4 [
            sprout 1 [  ;; make a new turtle at the clicking location
              set color yellow
              set shape "circle"
              set last-turtle who - 1  ;; sets last-turtle to previously made turtle
              set mark (pxcor / 2)     ;; things are divided by two since the graph is twice as big as it needs to be so that it looks better
              set vel-data (pycor / 2)
              set acc-data (precision( (pycor - ([pycor] of turtle (last-turtle))) / (pxcor - ([pxcor] of turtle (last-turtle))) )2)
              create-link-with turtle (last-turtle)  ;; link to last turtle so a nice line graph is made
              output-type "Marker " output-type mark output-type "  "  ;; write data in output area
              output-type "Velocity " output-type vel-data output-type "  "
              output-type "Acceleration " output-print acc-data
            ]
          ]
        ] 
      ]
    ]
  ]
end

to edit-point
  let candidate min-one-of turtles [distancexy mouse-xcor mouse-ycor]  ;; looks for turtle under mouse
  set old-vel ([vel-data] of candidate)                                ;; saves old vel and acc data into a variable
  set old-acc ([acc-data] of candidate)
  if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
    watch candidate                                                    ;; halo turtle
    while [mouse-down?] [
      if (floor((round(mouse-ycor) + max-pycor) mod 2) = 0) and        
      (floor((round(mouse-xcor) + max-pxcor) mod 2) = 0) [             ;; turtle can only move to intersection points
        ask subject [
          ifelse turtle (who + 1) = nobody [                           ;; still building graph..
            if abs(mouse-ycor - [ycor] of turtle (who - 1)) <= 4 [     ;; |acceleration| < 2
              set ycor round(mouse-ycor)                               ;; move and update info
              set mark (pxcor / 2)
              set vel-data (pycor / 2)
              set acc-data (precision( (pycor - ([pycor] of turtle (who - 1))) / (pxcor - ([pxcor] of turtle (who - 1))) )2)
            ]
          ] [
            if abs(mouse-ycor - [ycor] of turtle (who + 1)) <= 4 and   ;; same stuff as above, but for editing already made graphs
            abs(mouse-ycor - [ycor] of turtle (who - 1)) <= 4 [
              set ycor round(mouse-ycor)
              set mark (pxcor / 2)
              set vel-data (pycor / 2)
              set acc-data (precision( (pycor - ([pycor] of turtle (who - 1))) / (pxcor - ([pxcor] of turtle (who - 1))) )2)
              ask turtle ([who] of subject + 1) [
                set acc-data (precision( (pycor - ([pycor] of turtle (who - 1))) / (pxcor - ([pxcor] of turtle (who - 1))) )2)
              ]
            ]
          ]
        ] 
      ]
    ]
    ask subject [
      if vel-data != old-vel [                                        ;; checks to make sure you actually changed stuff
        output-type "Marker " output-print mark                       ;; if you did, update output area
        output-type "Velocity changed from " output-type old-vel
        output-type " to " output-print vel-data
        output-type "Acceleration changed from " output-type old-acc
        output-type " to " output-print acc-data
      ]
    ]
    reset-perspective                                                 ;; turns off halo
  ]
end

;; Saves the turtle data into a text file that can be
;; read by the FormulaT-pitboss model

to save-graph-data
  let file user-new-file

  if ( file != false )
  [
    if file-exists? file [  ;; overwrites files of the same name
      file-delete file
    ]
    file-open file
    ask turtles
    [
      file-write mark
      file-write vel-data
      file-write acc-data
    ]
    file-close
  ]
end

to save-graph-image
  let file user-new-file

  if ( file != false )
  [
    if file-exists? file [  ;; overwrites files of the same name
      file-delete file
    ]
    export-view file
  ]
end

;; Loads previously made graph points.  Note: The links and the output
;; area are not recreated, this just recreates the turtles and moves
;; them to the correct spot.

to load-data
  create-turtles 20 [
    set shape "circle"
    set color yellow
    ]
  let file user-file

  if ( file != false )
  [
    set velocity-data []
    file-open file

    while [ not file-at-end? ]
      [ set velocity-data sentence velocity-data (list (list file-read file-read file-read)) ]

    user-message "File loading complete!"
    file-close
  ]
end

;; Moves the turtles to the correct location outlined in the loaded file.
to train-turtles
  ifelse ( is-list? velocity-data )
    [ 
      foreach velocity-data [ ask turtle first ? [ setxy (first ? * 2) (item 1 ? * 2)
        set mark first ? set vel-data item 1 ? set acc-data last ? ] ] ]
    [ user-message "You need to load in patch data first!" ]
  ask turtles [
    if who != 0 [
      create-link-with turtle (who - 1)
    ]
  ]
end

to next-race
  run "__magic-open \\"FormulaT-pitboss\\""              ;; should open the next race...
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
753
314
-1
-1
13.0
1
10
1
1
1
0
0
0
1
0
40
0
20
0
0
1
ticks

BUTTON
10
85
157
118
Interact with Graph
new-point-check
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
10
25
115
58
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

OUTPUT
320
350
695
505
12

TEXTBOX
165
50
212
68
Velocity
11
0.0
1

TEXTBOX
483
328
524
346
Marker
11
0.0
1

BUTTON
10
125
115
158
Export Data
save-graph-data
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
10
165
115
198
Export Graph
save-graph-image
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
10
205
113
238
Load Points
setup\\nload-data\\ntrain-turtles
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
10
320
305
530
Making a new graph:\\nPress \\"setup\\" and then \\"Interact with Graph\\" to begin creating and editing graphs!  When you're done, export your data to a text file to be loaded into a model and/or export your graph as an image!\\n\\nImporting previously created graphs:\\nJust click \\"setup,\\" and then \\"Load Points.\\"  Once an old graph is loaded you can edit the graph by pressing \\"Interact with Graph\\" and then clicking and draging points to new locations.\\n\\nMake sure you add a point for every marker location! New points must increase in x-value and cannot have a |slope| > 2.
11
0.0
1

TEXTBOX
125
140
189
158
Save as .txt
11
0.0
1

TEXTBOX
125
177
193
195
Save as .png
11
0.0
1

BUTTON
10
244
113
277
Pitboss Race
next-race
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
VERSION
-------
$Id: FormulaT-graphing.nlogo 44494 2009-09-27 21:05:35Z nholbert $


WHAT IS IT?
-----------
This model is a graphing tool meant to be used with the FormulaT-pitboss model though it could be easily adapted for other uses.  In it you can plot points along an x and y axis and then export this data into a .txt file that can then be loaded in other models. The view can also be exported so that the user has a "hard copy" of their graph.


HOW IT WORKS
------------
When the user presses "setup" the model creates a grid complete with a labeled x and y axis (labels are coordinates divided by 2 so that size of the graphing space is adequate.

After pressing the "new-point" button, the user can click on intersection locations in the view to add new points.  These new points are actually turtles that create a link to the previously created turtle.  Also, as new points are added important data about these points are written into the output area.

Finally, when the user is satisfied with their graph they can export their data into a simple text file that can be loaded into other models, and/or they can export the view as a png file for later viewing.  Previously exported data can also be loaded into the view using the "Load Points" button.


HOW TO USE IT
-------------
To make a new graph the user simply needs to press "setup" and then "new-point."  Clicking in the view will add new points to the graph.  Users cannot create points with xcor <= previously created points and they cannot add points so the |slope| > 2 .  Make sure to add a point for each "Marker" (xcor intersections) so that the data will be properly compiled.

When satisfied with the graph, the user simply presses the "Export Data" button, chooses the location and name of their data file (these should end in .txt), and then clicks save.  The view can also be exported by pressing "Export Graph."  Graphs should be saved as .png files.

If the user would like to load the points to a previously created graph, simply press "Load Points," choose the appropriate data file, and press "save" (note, the file is not actually saved but loaded and consequently will not replace your file!).


THINGS TO NOTICE
----------------
Once you've run your graph in the FormulaT-pitboss model, try comparing the plot created by your car to the graph you made in this model.  Do they look similar?  Are they different?  Why?

When you plot a new on the graph you'll notice the output area write the marker, velocity, and acceleration.  Acceleration is not a label for either axis.  Can you figure out how the acceleration is calculated?


THINGS TO TRY
-------------
Many different graphs will create successful runs in the FormulaT-pitboss model.  Try a variety of graphs to try to get the fastest time possible!


EXTENDING THE MODEL
-------------------
This graph model could easily be adapted for a variety of uses.  Feel free to borrow and steal code to make a graphing tool for your model!

Try changing this graph so that instead of graphing velocity on the y axis, acceleration is plotted.  How does this graph compare to the velocity graph?


NETLOGO FEATURES
----------------
This model makes use of links, as well as importing and exporting features of Netlogo.


RELATED MODELS
--------------
All FormulaT models.


CREDITS AND REFERENCES
----------------------
Created by Nathan Holbert 6/25/09
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1RC4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
