breed [persons person]
breed [viruses virus]


persons-own [infectious-period p-contagious susceptible infectious immunity vaccination]
viruses-own [infection infection-period]

Patches-own [ ]
Globals [max-daily-cases breakthrough]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Setup procedures
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to setup
  clear-all
  set-default-shape viruses "c-virus-0"

  set-patches
  setup-people
  add-an-infectious
  ;color-code

  reset-ticks
end

to set-patches
  ask patches [set pcolor 9 + random-float 1]
end

to setup-people
  let masking (population * %-of-masking / 100)
  ask n-of masking  patches
  [ sprout-persons 1
    [set size 0.9
     set color 56
      set shape "person-1"
     set susceptible true
     set infectious false
     set immunity 0
     set infectious-period 0
     set vaccination false
     ]
  ]

    ask n-of (population - masking) patches
  [ sprout-persons 1
    [set size 0.9
     set color 56
     set shape "person-0"
     set susceptible true
     set infectious false
     set immunity 0
     set infectious-period 0
     set vaccination false
     ]
  ]

 let vaccinated (population * Vaccination-rate / 100)
  ask n-of vaccinated persons with [susceptible = true and infectious = false]
  [set susceptible false
   set infectious false
   set immunity Transmission-Rate
   set p-contagious Transmission-Rate
   set vaccination true
    set color 97]




end

to add-an-infectious
  ask one-of persons
  [set color 27
   set susceptible false
   set infectious true
   set p-contagious Transmission-Rate
   hatch-viruses 1 [
      set size 0.5
      set infection Transmission-Rate
      set color 35
      ;set-v-color
  ]]

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Go procedures
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to go

  if ticks > 0 and not any? persons with [susceptible = false and infectious = true] [stop]


  move
  produce-viruses
  infect
  virus-ability
  recover
  ;color-code
  find-max-daily-cases
  ;plot-levels
  tick
end

to move
  ask viruses
  [right random 360 forward 0.5]

end

to produce-viruses
  ask persons with [susceptible = false and infectious = true]                   ;ask infectious people
  [ifelse shape = "person-1"                      ;if masking
    [if random 100 < 50                             ;at a chance of 50%
      [hatch-viruses 1 [                              ;produce a new virus
        set size 0.5                                ;set the size of a virus
          set infection [p-contagious] of myself  ;not mutate
        set color 35
        ;set-v-color]                                ;set virus color based on infection rate
  ]]]

    [hatch-viruses 1 [                              ;if no masking, always produce a new virus
        set size 0.5                                ;set the size of a virus
        set infection [p-contagious] of myself  ;not mutate
        set color 35
      ;set-v-color]]                                ;set virus color based on infection rate
]]]

end

to infect
  ask viruses
  [if any? persons with [infectious = false] in-radius 1.5
    [let infected-person one-of persons with [infectious = false] in-radius 1.5
     (ifelse
       [immunity] of infected-person > 0 and [shape] of infected-person = "person-1"  ;mutation lead to breakthough infection to a masked person,
           [if random 1000 < (0.05 * abs (infection - [immunity] of infected-person))     ;cut down 50% infection rate
               [move-to infected-person
                 ask infected-person
                  [set color 27
                   set susceptible false
                   set infectious true
                   set p-contagious [infection] of myself
                   set immunity [infection] of myself        ;update immunity
                  ]
             set breakthrough breakthrough + 1 die]]    ;ask virus to die after infecting a person

        [immunity] of infected-person > 0 and [shape] of infected-person = "person-0"  ;mutation lead to breakthough infection to an unmasked person,
            [if random 1000 < (0.1 * abs (infection - [immunity] of infected-person))     ;cut down 50% infection rate
              [move-to infected-person
               ask infected-person
                 [set color 27
                  set susceptible false
                  set infectious true
                  set p-contagious [infection] of myself
                  set immunity [infection] of myself        ;update immunity
                 ]
               set breakthrough breakthrough + 1 die]]    ;ask virus to die after infecting a person

        [immunity] of infected-person = 0 and [shape] of infected-person = "person-1"  ;first infection to a masked person,
            [if random 100 < infection * 0.5                       ;cut down 50% infection rate
               [move-to infected-person
                 ask infected-person
                  [set color 27
                   set susceptible false
                   set infectious true
                   set p-contagious [infection] of myself
                   set immunity [infection] of myself        ;update immunity
                  ]
                die]]    ;ask virus to die after infecting a person

        [immunity] of infected-person = 0 and [shape] of infected-person = "person-0"  ;first infection to an unmasked person,
            [if random 100 < infection
              [move-to infected-person
               ask infected-person
                [set color 27
                  set susceptible false
                  set infectious true
                  set p-contagious [infection] of myself
                  set immunity [infection] of myself        ;update immunity
                 ]
                die]])    ;ask virus to die after infecting a person
            ]]

end

to virus-ability
 ask viruses
  [ifelse infection-period >= 2 [die][set infection-period infection-period + 1]]
end

to recover
  ask persons with [susceptible = false and infectious = true]
  [ifelse infectious-period >= 7
    [ifelse random 100 < 10 [die] [set color 97 set susceptible false set infectious false set infectious-period 0]]   ;mortality equals 10%
    [set infectious-period infectious-period + 1]
  ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   supporting procedures
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to set-v-color   ; set colors of viruses
  (ifelse
    infection >= 80  [set color 15]
    infection < 80 and infection >= 60 [set color 127]
    infection < 60 and infection >= 40 [set color 117]
    infection < 40 and infection >= 20 [set color 35]
    infection < 20  [set color 75])
end

to plot-levels ;; this creates creates the bar graph
    set-current-plot "People infected by variants with different transmissibilities"
    clear-plot
    plot-pen-down
    set-current-plot-pen "< 20%"
  plotxy 0 count persons with [p-contagious < 20 and p-contagious > 0]
    set-current-plot-pen "20%~39%"
  plotxy 1 count persons with [p-contagious < 40 and p-contagious >= 20]
    set-current-plot-pen "40%~59%"
  plotxy 2 count persons with [p-contagious < 60 and p-contagious >= 40]
    set-current-plot-pen "60%~79%"
  plotxy 3 count persons with [p-contagious < 80 and p-contagious >= 60]
    set-current-plot-pen ">= 80%"
  plotxy 4 count persons with [p-contagious >= 80]

end

to set-p-color  ; set colors of people
  ask persons
 [ (ifelse
    p-contagious >= 80 and vaccination = false [set color 15]
    p-contagious < 80 and p-contagious >= 60 and vaccination = false [set color 127.5]
    p-contagious < 60 and p-contagious >= 40 and vaccination = false [set color 117.5]
    p-contagious < 40 and p-contagious >= 20 and vaccination = false [set color 36]
    p-contagious < 20 and p-contagious > 0 and vaccination = false  [set color 75]
    p-contagious = 0 [set color 7]
    )]
end

to set-SIR-color
  ask persons
 [ (ifelse
    susceptible = true and infectious = false [set color 56]
    susceptible = false and infectious = true [set color 27]
    susceptible = false and infectious = false [set color 97]
    susceptible = true and infectious = true [set color 0])]
end

;to color-code
 ;(ifelse
 ; Color-coding-modes = "Susceptible-infectious-recovered" [set-SIR-color]
 ; Color-coding-modes = "Variant transmission rates" [set-p-color])
;end

to find-max-daily-cases
  if count persons with [susceptible = false and infectious = true] > max-daily-cases        ;Count the infectious.If it is greater than the current record of max daily cases
  [set max-daily-cases count persons with [susceptible = false and infectious = true]]       ;update the max daily case
end
@#$#@#$#@
GRAPHICS-WINDOW
7
98
465
557
-1
-1
18.0
1
10
1
1
1
0
0
0
1
-12
12
-12
12
1
1
1
ticks
15.0

BUTTON
514
19
619
80
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
629
19
721
80
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
731
19
813
79
Run a day
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
15
52
246
85
Transmission-Rate
Transmission-Rate
0
100
50.0
1
1
%
HORIZONTAL

SLIDER
15
10
246
43
Population
Population
50
600
300.0
50
1
People
HORIZONTAL

PLOT
476
98
863
453
Population over Time
Days
% of population
0.0
10.0
0.0
1.0
true
true
"" ""
PENS
"Susceptible" 1.0 0 -10899396 true "" "plot count persons with [susceptible = true and infectious = false] / population"
"Infectious" 1.0 0 -955883 true "" "plot count persons with [susceptible = false and infectious = true] / population"
"Recovered" 1.0 0 -13791810 true "" "plot count persons with [susceptible = false and infectious = false] / population"

SLIDER
259
10
467
43
%-of-masking
%-of-masking
0
100
0.0
1
1
%
HORIZONTAL

MONITOR
501
513
605
558
Max daily cases
max-daily-cases
0
1
11

MONITOR
501
462
593
507
Susceptible
count persons with [susceptible = true and infectious = false]
0
1
11

MONITOR
678
462
763
507
Recovered
count persons with [susceptible = false and infectious = false]
0
1
11

MONITOR
595
462
676
507
Infectious
count persons with [susceptible = false and infectious = true]
0
1
11

MONITOR
610
513
730
558
Outbreak Duration
ticks
0
1
11

MONITOR
765
462
834
507
Death
population - count persons
0
1
11

TEXTBOX
17
565
74
583
SIR colors:
9
0.0
1

TEXTBOX
24
577
111
595
|Green:susceptible
9
54.0
1

TEXTBOX
24
589
174
607
|Orange:infectious
9
25.0
1

TEXTBOX
24
602
174
620
|Blue:recovered
9
94.0
1

SLIDER
259
55
466
88
Vaccination-rate
Vaccination-rate
0
100
0.0
1
1
%
HORIZONTAL

MONITOR
735
512
833
557
NIL
breakthrough
17
1
11

@#$#@#$#@
## WHAT IS IT?
This model allows students to compare the effects of vaccination and masking on the max daily cases and epidemic duration in a population. Both human beings and viruses are represented in the model. 


## HOW IT WORKS

1. Susceptible-infectious-recovered (SIR) model is used to build the present model.

2. The model starts with a population of susceptible people (green) and one infectious person (orange). The infectious person carries the virus strain with a transmission rate defined by the transmission-rate slide. 

3. In each tick, each unmasked infectious person produces a new virus with the same transmission rate. We assume no mutation in this model. The masked infectious person produces a new virus at a 50% of chance (i.e., the mask may prevent them from releasing the same amount of viruses to the environment). 

4. The new virus may float 0.5 steps in a random direction and infect one of susceptible people within a radius of 1.5 at its transmission rate. The virus loses its ability to infect people if no susceptible people are within the infection radius.

5. Infectious people remain contagious for six days. They either recover (become blue) or die at a mortality rate of 10%. No new people join this model. 

6. Users may set up the percentage of masking in the population. The masked infectious people release 50% less viable viruses than unmasked infectious people. The transmission rate of a virus decreases by 50% when infecting a masked susceptible person (i.e., 70% become 35%, 50% become 25%, and so on). 

7. Users may set up the percentage of vaccinated people in the population. The present model assumes the vaccinated people will not be infected.  However, the vaccinated people may get a breakthrough infection at a low chance when viruses mutate. 


## HOW TO USE IT

1. First, choose the factors, such as population size,  transmission rate, etc.

2. Click on **Set up/Reset**, then **Run/Pause**. The model is set to stop when there are no infectious people. 

3. Observe the infection changes in the population in the plot and monitor.

4. Use **Run one day** to run the model in a controlled way and collect day-by-day data.


## THINGS TO TRY

Collect the data of the max daily cases and epidemic duration to examine the effects of vaccination rates and % of masking.


## RELATED MODELS

Find this model series at http://3dsciencemodeling.com

* Infectious Disease Outbreak-Basic Phenomenon
* Infectious Disease Outbreak-Transmission and mortality
* Infectious Disease Outbreak-Population Comparison
* Infectious Disease Outbreak-HealthCare, Isolation and Quarantine
* Infectious Disease Outbreak-Social distancing
* Infectious Disease Outbreak-Vaccination
* Infectious Disease Outbreak-SEIR model
* Infectious Disease Outbreak-variants



## CREDITS AND REFERENCES

Dr. Lin Xiang (lin.xiang@uky.edu) created this model at the University of Kentucky in 2023. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2023). Infectious Disease Outbreak-vaccination and masking. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.

Science Brief: Community Use of Masks to Control the Spread of SARS-CoV-2  https://www.cdc.gov/coronavirus/2019-ncov/science/science-briefs/masking-science-sars-cov2.html
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

c-virus
true
0
Circle -7500403 true true 53 51 196
Circle -7500403 true true 203 234 16
Polygon -7500403 true true 43 208 82 179 92 196 46 215
Polygon -7500403 true true 257 208 218 179 208 196 254 215
Polygon -7500403 true true 43 92 82 121 92 104 46 85
Polygon -7500403 true true 257 92 218 121 208 104 254 85
Circle -7500403 true true 251 73 22
Polygon -7500403 true true 146 271 141 225 160 226 155 271
Polygon -7500403 true true 146 29 141 75 160 74 155 29
Polygon -7500403 true true 209 245 188 221 195 209 213 241
Polygon -7500403 true true 209 55 188 79 195 91 213 59
Circle -7500403 true true 203 50 16
Circle -7500403 true true 81 50 16
Polygon -7500403 true true 91 55 112 79 105 91 87 59
Polygon -7500403 true true 91 245 112 221 105 209 87 241
Circle -7500403 true true 81 234 16
Polygon -7500403 true true 260 147 230 142 229 157 260 154
Circle -7500403 true true 256 143 16
Circle -7500403 true true 28 143 16
Polygon -7500403 true true 40 147 70 142 71 157 40 154
Circle -7500403 true true 27 73 22
Circle -7500403 true true 27 205 22
Circle -7500403 true true 251 205 22
Circle -7500403 true true 139 270 22
Circle -7500403 true true 139 8 22
Polygon -6459832 true false 135 90 180 120 150 135 180 150 150 165 180 180 135 210 135 210 120 210 165 180 135 165 165 150 135 135 165 120 120 90

c-virus-0
true
0
Circle -7500403 true true 59 58 182
Polygon -6459832 true false 135 90 180 120 150 135 180 150 150 165 180 180 135 210 135 210 120 210 165 180 135 165 165 150 135 135 165 120 120 90
Polygon -7500403 true true 15 165 15 135 30 126 60 150 30 173
Polygon -7500403 true true 204 257 192 261 184 254 188 234 205 247
Polygon -7500403 true true 135 15 165 15 174 30 150 60 127 30
Polygon -7500403 true true 285 135 285 165 270 174 240 150 270 127
Polygon -7500403 true true 165 285 135 285 126 270 150 240 173 270
Polygon -7500403 true true 66 253 45 235 48 221 85 213 80 248
Polygon -7500403 true true 43 204 39 192 46 184 66 188 53 205
Polygon -7500403 true true 96 257 108 261 116 254 112 234 95 247
Polygon -7500403 true true 257 96 261 108 254 116 234 112 247 95
Polygon -7500403 true true 257 204 261 192 254 184 234 188 247 205
Polygon -7500403 true true 43 96 39 108 46 116 66 112 53 95
Polygon -7500403 true true 96 43 108 39 116 46 112 66 95 53
Polygon -7500403 true true 204 43 192 39 184 46 188 66 205 53
Polygon -7500403 true true 47 66 65 45 79 48 87 85 52 80
Polygon -7500403 true true 234 47 255 65 252 79 215 87 220 52
Polygon -7500403 true true 253 234 235 255 221 252 213 215 248 220

c-virus-1
true
0
Circle -7500403 true true 44 43 212
Polygon -6459832 true false 135 90 180 120 150 135 180 150 150 165 180 180 135 210 135 210 120 210 165 180 135 165 165 150 135 135 165 120 120 90
Polygon -7500403 true true 285 135 285 165 272 155 240 150 272 145
Polygon -7500403 true true 135 15 165 15 155 28 150 60 145 28
Polygon -7500403 true true 135 285 165 285 155 272 150 240 145 272
Polygon -7500403 true true 15 135 15 165 28 155 60 150 28 145
Polygon -7500403 true true 60 267 31 240 54 237 79 218 61 244
Polygon -7500403 true true 33 60 60 31 63 54 82 79 56 61
Polygon -7500403 true true 240 33 269 60 246 63 221 82 239 56
Polygon -7500403 true true 267 240 240 269 237 246 218 221 244 239
Polygon -7500403 true true 210 39 191 30 193 41 186 66 198 44
Polygon -7500403 true true 90 39 109 30 107 41 114 66 102 44
Polygon -7500403 true true 261 90 270 109 259 107 234 114 256 102
Polygon -7500403 true true 210 261 191 270 193 259 186 234 198 256
Polygon -7500403 true true 39 210 30 191 41 193 66 186 44 198
Polygon -7500403 true true 261 210 270 191 259 193 234 186 256 198
Polygon -7500403 true true 90 261 109 270 107 259 114 234 102 256
Polygon -7500403 true true 39 90 30 109 41 107 66 114 44 102

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

humanbust
true
0

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person-0
false
0
Circle -7500403 true true 75 0 150
Polygon -7500403 true true 151 166 178 165 203 163 225 164 243 167 262 175 279 189 292 208 299 230 300 249 298 275 293 290 260 295 205 299 151 299 95 298 38 295 5 287 2 270 0 248 4 226 14 202 29 183 42 172 57 165 76 163 99 163 124 164 151 166

person-1
false
0
Circle -7500403 true true 74 0 150
Polygon -7500403 true true 151 166 178 165 203 163 225 164 243 167 262 175 279 189 292 208 299 230 300 249 298 275 293 290 260 295 205 299 151 299 95 298 38 295 5 287 2 270 0 248 4 226 14 202 29 183 42 172 57 165 76 163 99 163 124 164 151 166
Polygon -1 true false 74 66 92 71 148 62 206 73 223 67 225 71 208 77 203 124 202 128 200 131 193 136 149 145 106 136 102 133 97 129 94 123 89 75 74 71

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
