breed [trees tree]
breed [beetles beetle]

beetles-own [age]
trees-own [attack pheromone]
globals [dead-trees forest-lost total-dead-trees max-dead-trees max-b-population b-population cut-down-trees]


to setup
  clear-all
  setup-beetles
  setup-trees
  setup-patches

  reset-ticks
end

to setup-trees
  ask patches
  [if not any? trees-here
    [if random 100 < 80
      [sprout-trees 1
      [set color 54
       set size 1.5 + random-float 1
       set shape "pine"
       set attack 0
       set pheromone 0]
  ]]]

end

to setup-beetles
  create-beetles Starting-number-of-beetles
  [set color 0
    set size 0.5
    set shape "bark-beetle"
    set age 0
    setxy random-xcor random-ycor
  ]
end


to setup-patches
  ask patches [set pcolor 37 + random-float 1]
end

to go

  if ticks >= years [stop]
  ;if not any? beetles [stop]

  move-infest
  attacking
  beetle-mortality
  beetle-flight
  tree-sapling
  tree-grow
  count-dead-trees
  clean-pheromone
  thinning-trees
  forest-management
  tick
end


to forest-management
  (ifelse
     Cut-down-trees? = "never"
      []

     Cut-down-trees? = "when they are lightly infested"
      [ask trees with [attack > 5]
        [ask beetles-here [die]
         set cut-down-trees cut-down-trees + 1
         die]]

     Cut-down-trees? = "only when they are heavily infested"
      [ask trees with [attack > 35 - (drought-severity * 5)]
        [ask beetles-here [die]
         set cut-down-trees cut-down-trees + 1
         die]]
    )
end

to thinning-trees
 ask trees with [size >= 1.75]
        [if random 100 < Thinning [set cut-down-trees cut-down-trees + 1 die]]
end


to clean-pheromone
  ask trees [set pheromone 0]
end

to  beetle-flight  ;mature beetle flight for new trees
 ask beetles
   [right random 360 forward 1 + random-float 2]

end
to count-dead-trees

  set total-dead-trees dead-trees
  if total-dead-trees > max-dead-trees
    [set max-dead-trees total-dead-trees]
  set dead-trees 0

  set b-population count beetles
  if b-population > max-b-population
  [set max-b-population b-population]

end


to tree-sapling
 ask patches
  [if not any? trees-here
    [if random 100 < 5
      [sprout-trees 1
      [set color 54
       set size 1
       set shape "pine"
       set attack 0
       set pheromone 0]]]]
end


to tree-grow
 ask trees
  [if size <= 2.5
    [set size size + 0.05]]
end

to beetle-mortality
  ask beetles
  [ if age >= 2 [die]
    if random 100 < 49 - avg-winter-temperature-increase * 2 [die]
  ]
end

to attacking
  ask trees
  [(ifelse
    attack > 35  - (drought-severity * 5) and attack < 50  - (drought-severity * 5)
      [set color 26]
    attack >= 50  - (drought-severity * 5)
      [set dead-trees dead-trees + 1 set forest-lost forest-lost + 1 die ])]
end

to move-infest
   ask beetles
  [ifelse any? trees with [pheromone > 0 and attack < 50 - (drought-severity * 5)] in-radius 5           ;if there are trees with pheromone and not fully-occupied in a radius of 5
    [let candidate-trees trees with [pheromone > 0 and attack < 50  - (drought-severity * 5)] in-radius 5      ;if so, let these trees to be the candidate trees
      let my-tree one-of candidate-trees with-max [pheromone]                   ; let one of candidate trees with the max pheromone be my tree
       move-to my-tree                                                          ;infest the tree and reproduce and die
       hatch 2 [set age 0]
        ask my-tree [set attack attack + 2 set pheromone pheromone + 1]

        if random 100 < avg-summer-temperature-increase * 4                     ;effect of rising temperature
           [hatch 2 [set age 0]
            ask my-tree [set attack attack + 2 set pheromone pheromone + 1]]
       die]

    [ifelse any? trees with [size >= 1.75 and pheromone <= 0 ] in-radius 2            ;otherwise, if there are mature non-infested trees in a radius of 2
      [let candidate-trees trees with [size >= 1.75 and pheromone <= 0 ] in-radius 2  ; if so, let these trees to be the candidate trees
       let my-tree one-of candidate-trees                                             ; let one of candidate trees be my tree
        move-to my-tree                                                               ;infest the tree and reproduce and die
        hatch 2 [set age 0]
        ask my-tree [set attack attack + 2 set pheromone pheromone + 1]

        if random 100 < avg-summer-temperature-increase * 4                     ;effect of rising temperature
           [hatch 2 [set age 0]
            ask my-tree [set attack attack + 2 set pheromone pheromone + 1]]
        die]

      [right random 360 forward 1 + random-float 2 set age age + 1]                         ;otherwise, randomly move and increase age
    ]]
end
@#$#@#$#@
GRAPHICS-WINDOW
5
306
319
621
-1
-1
18.0
1
10
1
1
1
0
1
1
1
-8
8
-8
8
0
0
1
ticks
15.0

BUTTON
3
10
108
43
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
3
47
231
80
Starting-number-of-beetles
Starting-number-of-beetles
0
50
50.0
1
1
NIL
HORIZONTAL

BUTTON
113
10
214
43
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
416
10
504
51
Living Trees
count trees
17
1
10

MONITOR
326
10
414
51
Beetles
count beetles
17
1
10

PLOT
326
239
656
422
Populations
Time
Count
0.0
10.0
0.0
300.0
true
true
"" ""
PENS
"Living Tree" 1.0 0 -10899396 true "" "plot count Trees"
"Dead Trees" 1.0 0 -13791810 true "" "plot total-dead-trees"
"Beetles" 1.0 0 -2674135 true "" "plot count beetles "

SLIDER
3
122
317
155
avg-summer-temperature-increase
avg-summer-temperature-increase
0
2
0.0
.5
1
Celsius
HORIZONTAL

SLIDER
3
159
317
192
avg-winter-temperature-increase
avg-winter-temperature-increase
0
2
0.0
0.5
1
Celsius
HORIZONTAL

INPUTBOX
237
47
317
114
Years
150.0
1
0
Number

BUTTON
219
10
317
43
Run a year
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
3
83
231
116
drought-severity
drought-severity
0
3
0.0
1
1
Levels
HORIZONTAL

MONITOR
506
10
589
51
Dead Trees
total-dead-trees
17
1
10

MONITOR
326
57
492
98
Max Beetle Population Size
max-b-population
17
1
10

MONITOR
326
102
492
143
Max Annual Tree Loss
max-dead-trees
17
1
10

MONITOR
591
10
648
51
Years
ticks
17
1
10

PLOT
326
425
656
621
Forest Decline over Time
Years
Count
0.0
10.0
0.0
50.0
true
true
"" ""
PENS
"Dead Trees" 1.0 1 -13791810 false "" "plot total-dead-trees"

MONITOR
326
147
498
188
Max Annual Forest Decline (%)
(max-dead-trees * 100) / (world-width * world-height)
2
1
10

CHOOSER
23
199
292
244
Cut-down-trees?
Cut-down-trees?
"never" "when they are lightly infested" "only when they are heavily infested"
0

MONITOR
326
192
498
233
Total of trees being cut down
cut-down-trees
2
1
10

TEXTBOX
497
61
690
100
<--The largest beetle population over the entire simulated time (i.e., 150 years).
10
125.0
1

TEXTBOX
496
109
715
148
<--The largest number of trees that are killed in a year over time (i.e., 150 years).
10
125.0
1

TEXTBOX
502
154
718
193
<--Percent of forest decline in the year when the largest number of trees are killed
10
125.0
1

TEXTBOX
501
197
693
230
<--The total number of trees being cut down over time (i.e., 150 years).
10
125.0
1

SLIDER
23
252
292
285
Thinning
Thinning
0
10
0.0
1
1
% of mature trees
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model simulates climate-driven bark beetle outbreaks. Compared to the basic "Bark Beetle Epidemic" model, which presents students with the impact of temperature and droughts on bark beetle outbreaks, this model separates the effects of rising temperatures on beetle reproduction and survival. This model also allows students to explore the impacts of sanitation cutting, salvage cutting, and thinning on beetle outbreak.  

## HOW IT WORKS

### Agents:

There are two types of agents: beetles and host trees.

### Model Rules:

1. The model has 289 patches (light brown squares). Each patch may grow one pine tree.

2. Bark beetles follow pheromone to find their host tree. They always first infest the tree with the strongest pheromone (i.e., max pheromone) and are not fully occupied (i.e., attack < 50). 

3. If no pheromone is sensed, bark beetles attack a mature tree (i.e., with a size no smaller than 1.75) nearby and release pheromones to attract other dispersing beetles.

4. Once infesting a tree, each bark beetle produces 2 offspring beetles and counts as 2 attacks on the tree. When the average temperature rises in summer, some beetles may produce another 2 offspring beetles.

5. Beetles may live two hypothetical years and die after reproduction. Each year, 49% of the beetles die during winter. When the average temperature rises in winter, fewer beetles die.

6. Trees become reddish after receiving 35 attacks and die after getting 50 attacks. Droughts will lower the tree defense threshold from 50 to 45, 40, or 35.

7. Every empty patch grows a new pine tree at a chance of 5% each year.



## HOW TO USE IT

1.        Use the slider **Starting-number-of-beetles** to set up the starting beetle population. Click **Start/Reset** to confirm the settings.

2.        Put a number in **years** to define when the model ends.

3.        Click **Run/Pause** to run or pause the model. Good for gaining an overview and a long-term result.

4.        Click **Run a year** to run the model for a hypothetical year. Good for systematically collecting data. 

5.        Use sliders to define the temperature increases and the severity of droughts. 

6.   Use switch ** Cut-down-trees? ** to choose whether and how to cut down trees to mitigate the outbreak.

7.       Use the slider **Thinning** to set up how many percent of mature trees to be cut down for thinning the forest. These trees include the infected and the uninfested. 


## THINGS TO NOTICE & TRY

* Can you identify an outbreak in the model? How?

* How many outbreaks may occur over 150 years when there are no droughts and no increases in temperatures?

* How many outbreaks may occur over 150 years when there are droughts and increases in temperatures?

* How do droughts and/or rising temperatures affect the number of dead trees?

* How does cutting down infested trees affect the outbreak occurrences and tree loss?

* How does thinning forests affect the outbreak occurrences?


## CREDITS AND REFERENCES

Dr. Lin Xiang created this module at the University of Kentucky in 2022. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2022). Climate-driven Bark Beetle Outbreaks. Department of STEM Education, University of Kentucky, Lexington, KY.


![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bark-beetle
true
0
Polygon -7500403 true true 152 17 135 17 122 27 115 38 110 54 102 63 95 80 90 105 116 114 132 111 152 111
Polygon -7500403 true true 148 17 165 17 178 27 185 38 190 54 198 63 205 80 210 105 182 114 168 111 148 111
Polygon -7500403 true true 151 109 124 109 106 117 97 119 91 126 92 167 90 203 90 243 100 262 117 280 133 290 148 292 152 292
Polygon -7500403 true true 149 109 176 109 194 117 203 119 209 126 208 167 210 203 210 243 200 262 183 280 167 290 152 292 148 292
Polygon -7500403 true true 128 27 114 21 111 23 109 26 108 30 99 30 93 23 87 20 85 29 93 37 109 33 115 27
Polygon -7500403 true true 172 27 186 21 189 23 191 26 192 30 201 30 207 23 213 20 215 29 207 37 191 33 185 27
Polygon -7500403 true true 95 92 84 85 80 85 77 81 68 65 63 63 55 51 46 49 45 50 51 52 48 60 51 56 54 58 63 69 62 71 78 89 78 93 93 103
Polygon -7500403 true true 205 92 216 85 220 85 223 81 232 65 237 63 245 51 254 49 255 50 249 52 252 60 249 56 246 58 237 69 238 71 222 89 222 93 207 103
Polygon -7500403 true true 94 127 84 122 44 141 39 139 41 142 35 142 42 145 24 166 14 172 18 181 17 173 25 168 27 171 29 164 43 148 46 149 77 130 93 148
Polygon -7500403 true true 206 127 216 122 256 141 261 139 259 142 265 142 258 145 276 166 286 172 282 181 283 173 275 168 273 171 271 164 257 148 254 149 223 130 207 148
Polygon -7500403 true true 94 183 76 194 62 224 58 227 65 223 62 239 55 252 59 249 63 254 62 243 67 247 69 224 76 205 95 200
Polygon -7500403 true true 206 183 224 194 238 224 242 227 235 223 238 239 245 252 241 249 237 254 238 243 233 247 231 224 224 205 205 200

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

pine
false
0
Polygon -6459832 true false 135 180 135 270 105 285 150 284 165 300 165 285 195 285 166 265 165 180
Polygon -7500403 true true 150 0 120 30 135 30 105 45 120 45 90 75 105 75 75 105 90 105 60 150 75 150 45 195 120 180 180 180 255 195 225 150 240 150 210 105 225 105 195 75 210 75 180 45 195 45 165 30 180 30
Polygon -11221820 false false 150 0 120 30 135 30 105 45 120 45 90 75 105 75 75 105 90 105 60 150 75 150 45 195 120 180 180 180 255 195 225 150 240 150 210 105 225 105 195 75 210 75 180 45 195 45 165 30 180 30

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
