globals [x y fish-color name]

breed [fish a-fish]
breed [weeds weed]
breed [pebbles pebble]
breed [foods food]

to-report min-color
  report (round min [color] of fish) - 0.5
end

to-report max-color
  report (round max [color] of fish) + 0.5
end

to-report generation
  report ticks / 25000
end

to setup
  ca

ask patches [set pcolor 87.5]
ask patches with [pycor = min-pycor] [set pcolor 35]


  create-fish 30                                                                              ;set fish
  [set color 24 + random-float 3
    set heading 90
    ifelse heading >= 0 or heading <= 180 [set shape "fish-ll"][set shape "fish-rr"]
    set size 5
    set label round color

   setposition
  ]


create-weeds 1 + random 2                                                                      ;set aquatic plants
[set color green
  set size 10 + random 3
  set shape "weed"
  setxy random-xcor min-pycor + 6 + random 2]


create-pebbles 300                                                                              ;set pebbles
[set size 1 + random-float 1.5
  set color 34 + random 5
  set shape "pebble"
  setxy random-xcor min-pycor + random-float 1.5]


  reset-ticks
end

to setposition
  ifelse turtles-here != nobody [setxy random-xcor random-ycor][setposition]
end

to go
  tick
every 0.1 [
swim
fish-grow
death
reproduce
pick-a-fish
do-plot]
end


to swim
     ask fish [
    rt random-float 45
    lt random-float 45
     if [pycor] of patch-ahead 1 < min-pycor + 3 [set heading random 90]                          ;move up if get to the bottom
     if [pycor] of patch-ahead 1 > max-pycor - 3 [set heading 90 + random 90]                     ; move down if get to the surface
    ifelse heading >= 0 and heading <= 180 [set shape "fish-ll"][set shape "fish-rr"]               ; set fish side aligned with heading
    fd 0.3
     ]
end

to set-shape
  ask turtles
  [ifelse heading >= 0 or heading <= 180 [set shape "fish 9"][set shape "fish 8"]]
end

to death
  ask fish [if count fish >= 30 [if random 100 < 1 [die]]]
end

to reproduce
  ask fish with [size = 5] [if count fish < 30 [hatch 1 [set color (color - 1 + random-float 2) round-color set size 0.5 set label round color setxy random-xcor min-pycor + 3 + random 2]]]
end

to fish-grow
  ask fish [if size < 5 [set size size + 0.2]]
end

to round-color
  if round color = 9 or round color = 10 [set color 12]
    if round color = 19 or round color = 20 [set color item random 2 [ 18 22]]
    if round color = 29 or round color = 30 [set color item random 2 [ 28 32]]
   if round color = 39 or round color = 40 [set color item random 2 [ 38 42]]
   if round color = 49 or round color = 50 [set color 48]
end


to pick-a-fish

 clear-output
    if mouse-inside? [
    if mouse-down? [
      set x round mouse-xcor set y round mouse-ycor
      ask fish with-min [distancexy x y] [set fish-color color]
      ask fish [die]

      create-fish 1                                                                              ;set a new fish like the picked one
       [set color fish-color
        set heading 90
        ifelse heading >= 0 or heading <= 180 [set shape "fish-ll"][set shape "fish-rr"]
        set size 5
        set label round color
     setxy  -5  5
       ]

       create-fish 1                                                                              ;set second new fish like the picked one
       [set color fish-color
        set heading -90
        ifelse heading >= 0 or heading <= 180 [set shape "fish-ll"][set shape "fish-rr"]
        set size 5
        set label round color

     setxy  5  5
       ]
      ;stop
    ]]
end

to pick-a-fish-1

 clear-output
    if mouse-inside? [
    if mouse-down? [
      set x round mouse-xcor set y round mouse-ycor
      ask fish with-min [distancexy x y] [set fish-color color]
      ask fish [die]

       create-fish 1                                                                              ;set a new fish like the picked one
       [set color fish-color
        set heading 90
        ifelse heading >= 0 or heading <= 180 [set shape "fish-ll"][set shape "fish-rr"]
        set size 5
        set label round color
     setxy  -5  5
       ]

       create-fish 1                                                                              ;set second new fish like the picked one
       [set color fish-color
        set heading -90
        ifelse heading >= 0 or heading <= 180 [set shape "fish-ll"][set shape "fish-rr"]
        set size 5
        set label round color
     setxy  5  5
       ]
      stop
    ]]
end


to do-plot
 ;set-current-plot "Average Size of Pumpkins"
 ;plot mean [size] of pumpkins

 set-current-plot "Distribution of Fish Color"
 set-plot-x-range 10 50
 histogram [color] of fish
end
@#$#@#$#@
GRAPHICS-WINDOW
10
10
750
391
-1
-1
12.0
1
10
1
1
1
0
1
1
1
-30
30
-15
15
0
0
1
ticks
30.0

BUTTON
755
69
901
145
Start a fish tank
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
755
160
901
232
Go! Fish go!
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
754
346
859
391
Number of fish
count fish
17
1
11

MONITOR
860
346
981
391
Generation
generation
0
1
11

PLOT
10
396
750
546
Distribution of Fish Color
Color
# of fish
10.0
50.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.1 1 -5825686 true "histogram [color] of fish" "histogram [color] of fish"

PLOT
754
393
982
543
Change of average fish color
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pen-1" 1.0 0 -2674135 true "plotxy generation mean [color] of fish" "plotxy generation mean [color] of fish"

BUTTON
755
248
901
318
Stop! Let me pick fish.
pick-a-fish-1
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
907
194
1055
223
<--Pick fish while they \n      are swimming.
10
125.0
1

TEXTBOX
906
262
1056
301
<--Fish moves too fast?\n       Stop them to pick fish,\n       then press go.
10
125.0
1

MONITOR
754
544
857
585
Average fish color
mean [color] of fish
1
1
10

TEXTBOX
94
544
676
562
Red                                   Orange                                  Brown                                 Yellow                    
14
0.0
1

@#$#@#$#@
## WHAT IS IT?
Have fun with breeding goldfish !!!!

This model helps students observing the phenomenon of variation. Students can breed a pair of goldfish. They will see some offspring's color always slightly different from their parents. This model also demonstrates artificial selection. Students can breed the fish to test how selection pressure affects fish color evolution over time. 

## HOW TO USE IT?

1. First, push "start a fish tank" to begin. The number attached to each fish indicate its color. e.g., 21-29 are different shades of orange, 11-19 are different shades of red. The fish color may be as dark as black when the number gets close to an integer multiple of 10, such as 10,20,30. 

2. Press "Go! Fish Go!" to let fish swim around. You may choose fish to breed at this time. You only select one fish with your desired color, and then the simulation will pair a fish with the same color to produce offspring fish. In this model, each pair of fish reproduce 30 offspring fish whose colors are determined by their parent color with some variation-either lighter or darker.

3. You may press "stop! Let me pick fish" to stop fish swimming so you can pick fish easily.

## HOW IT WORKS?

In this model, each pair of fish reproduce 30 offspring fish whose colors are determined by their parent color number, with some variation-either lighter or darker.
  

## CREDITS AND REFERENCES

This module is created by Dr. Lin Xiang at Weber State University. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2017). Artificial Selection-Fish Tank. Zoology Department, Weber State University, Ogden, UT.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

beetle
true
0
Circle -7500403 true true 140 69 20
Circle -7500403 true true 137 74 10
Circle -7500403 true true 153 74 10
Polygon -7500403 true true 150 84 150 252 129 245 115 235 109 223 101 209 99 182 96 154 94 127 90 119 88 112 95 106 111 102 127 99 135 91 138 81
Polygon -7500403 true true 141 81 140 65 135 47 125 33 112 24 98 16 91 17 97 22 106 25 118 34 125 39 134 54 136 66 138 77 141 84
Polygon -7500403 true true 132 105 108 84 76 98 61 90 44 92 62 95 75 104 108 90 122 109
Polygon -7500403 true true 150 84 150 252 171 245 185 235 191 223 199 209 201 182 204 154 206 127 210 119 212 112 205 106 189 102 173 99 165 91 162 81
Polygon -7500403 true true 97 139 81 136 51 169 36 172 29 187 41 176 53 175 80 142 99 151
Polygon -7500403 true true 102 182 86 179 61 232 47 238 40 254 52 241 66 235 87 186 105 199
Polygon -7500403 true true 159 81 160 65 165 47 175 33 188 24 202 16 209 17 203 22 194 25 182 34 175 39 166 54 164 66 162 77 159 84
Polygon -7500403 true true 168 105 192 84 224 98 239 90 256 92 238 95 225 104 192 90 178 109
Polygon -7500403 true true 203 139 219 136 249 169 264 172 271 187 259 176 247 175 220 142 201 151
Polygon -7500403 true true 198 182 214 179 239 232 253 238 260 254 248 241 234 235 213 186 195 199

beetle 1
true
0
Rectangle -16777216 true false 132 86 166 230
Polygon -7500403 true true 181 90 191 96 199 109 204 122 209 140 211 168 209 201 201 227 190 240 178 246 168 248 153 249 151 240 151 225 151 210 151 195 151 180 151 165 151 150 151 120 151 105 166 90 151 90 151 60 181 75
Polygon -7500403 true true 120 90 110 96 102 109 97 122 92 140 90 168 92 201 100 227 111 240 123 246 133 248 148 249 150 240 150 225 150 210 150 195 150 180 150 165 150 150 150 120 150 105 135 90 150 90 150 60 120 75
Circle -7500403 true true 135 45 30
Circle -7500403 true true 151 54 24
Circle -7500403 true true 127 54 24
Circle -7500403 true true 133 63 34
Circle -7500403 true true 158 70 26
Circle -7500403 true true 131 222 40
Polygon -7500403 true true 135 55 123 55 114 57 108 64 108 61 109 43 113 39 113 46 113 53 114 54 128 52 137 53
Polygon -7500403 true true 165 55 177 55 186 57 192 64 192 61 191 43 187 39 187 46 187 53 186 54 172 52 163 53
Polygon -7500403 true true 125 102 95 87 95 63 91 38 96 23 102 17 98 27 93 40 99 47 103 56 100 84 132 97
Polygon -7500403 true true 175 102 205 87 205 63 209 38 204 23 198 17 202 27 207 40 201 47 197 56 200 84 168 97
Polygon -7500403 true true 104 115 90 121 62 122 59 117 30 98 26 90 29 81 33 81 29 89 33 97 61 115 64 113 89 117 106 110
Polygon -7500403 true true 196 115 210 121 238 122 241 117 270 98 274 90 271 81 267 81 271 89 267 97 239 115 236 113 211 117 194 110
Polygon -7500403 true true 91 163 78 169 66 229 57 244 57 255 59 262 63 263 59 254 61 244 71 231 80 242 76 230 81 176 93 168
Polygon -7500403 true true 209 163 222 169 234 229 243 244 243 255 241 262 237 263 241 254 239 244 229 231 220 242 224 230 219 176 207 168
Circle -7500403 true true 116 70 26

bird
true
0
Polygon -7500403 true true 154 72 150 62 147 72 139 77 135 86 129 98 117 98 109 95 104 89 99 78 90 74 74 77 56 85 40 97 30 112 0 150 42 135 74 126 87 138 109 148 130 154 134 163 135 165 105 209 135 224 152 228 165 224 195 209 165 165 168 163 172 153 193 148 213 138 227 128 259 135 300 149 271 113 261 99 249 86 230 78 210 74 203 78 196 92 185 95 171 97 166 85 162 76

bird 1
false
0
Circle -7500403 true true 20 90 50
Polygon -7500403 true true 57 92 6 119 28 121 31 131 35 153 45 174 64 192 93 200 122 198 148 192 174 165 189 144 199 126 256 83 299 60 291 60 286 58 200 105 187 111 167 112 126 113 80 116 74 112
Polygon -7500403 true true 149 190 136 218 131 230 148 230 158 235 147 233 127 233 111 237 127 230 136 209 139 191
Polygon -7500403 true true 118 191 104 211 82 213 104 215 124 218 109 212

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

chiton
true
0
Polygon -7500403 true true 149 15 172 17 195 27 217 60 228 109 226 196 213 243 194 270 167 283 149 285
Polygon -7500403 true true 153 15 130 17 107 27 85 60 74 109 76 196 89 243 108 270 135 283 153 285
Polygon -1 true false 151 259 140 257 124 236 111 206 104 175 101 133 105 82 118 56 136 47 151 52
Polygon -1 true false 150 258 161 256 177 235 190 205 197 174 200 132 196 81 183 55 165 46 150 51
Polygon -7500403 true true 133 70 145 74 155 74 169 70 151 78 150 91 150 78
Polygon -7500403 true true 191 124 172 128 149 133 108 124 140 134 149 135 157 134
Polygon -7500403 true true 106 89 126 99 136 98 147 97 139 100 130 101 122 100
Polygon -7500403 true true 192 91 174 99 164 98 153 97 161 100 170 101 178 100
Polygon -7500403 true true 192 159 173 163 150 168 109 159 141 169 150 170 158 169
Polygon -7500403 true true 186 198 175 201 151 209 113 200 142 210 151 211 159 210

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

dragonfly
true
0
Circle -7500403 true true 148 57 18
Circle -7500403 true true 137 57 18
Circle -7500403 true true 144 54 14
Circle -7500403 true true 140 71 22
Circle -7500403 true true 144 96 14
Polygon -7500403 true true 150 105 144 104 145 120 147 164 148 180 148 192 147 202 152 209 156 203 155 192 155 180 156 165 158 122 158 101 155 107 153 108
Polygon -7500403 true true 142 80 116 76 71 70 48 69 28 70 18 79 20 89 42 97 80 96 113 92 141 88
Polygon -7500403 true true 141 91 128 94 99 101 68 112 55 116 41 123 38 136 50 142 103 139 123 133 133 117 138 103
Circle -7500403 true true 141 83 20
Polygon -7500403 true true 158 80 184 76 229 70 252 69 272 70 282 79 280 89 258 97 220 96 187 92 159 88
Polygon -7500403 true true 159 91 172 94 201 101 232 112 245 116 259 123 262 136 250 142 197 139 177 133 167 117 162 103

dragonfly 1
true
0
Circle -7500403 true true 148 57 18
Circle -7500403 true true 137 57 18
Circle -7500403 true true 144 54 14
Circle -7500403 true true 140 71 22
Circle -7500403 true true 144 96 14
Polygon -7500403 true true 150 105 144 104 145 120 147 164 148 180 148 192 147 202 152 209 156 203 155 192 155 180 156 165 158 122 158 101 155 107 153 108
Polygon -7500403 true true 142 80 116 76 71 70 48 69 28 70 18 79 20 89 42 97 80 96 113 92 141 88
Polygon -7500403 true true 141 91 128 94 99 101 68 112 55 116 41 123 38 136 50 142 103 139 123 133 133 117 138 103
Circle -7500403 true true 141 83 20
Polygon -7500403 true true 158 80 184 76 229 70 252 69 272 70 282 79 280 89 258 97 220 96 187 92 159 88
Polygon -7500403 true true 159 91 172 94 201 101 232 112 245 116 259 123 262 136 250 142 197 139 177 133 167 117 162 103
Polygon -16777216 true false 210 75 225 75
Line -16777216 false 256 71 242 71
Line -16777216 false 44 71 58 71
Line -16777216 false 245 118 231 113
Line -16777216 false 55 118 69 113

dragonfly 2
false
0
Polygon -7500403 true true 187 62 201 62 221 68 221 82 207 108 175 139 140 159 102 176 100 171 132 129 148 105 169 74
Polygon -7500403 true true 99 171 102 181 126 168 159 159 230 142 245 138 259 137 262 132 255 130 241 132 226 137 212 141 196 145 176 150 151 156 126 163
Polygon -16777216 true false 182 54 200 51 213 60 212 80 203 106 171 137 136 157 102 174 96 169 128 127 144 103 165 72
Circle -7500403 true true 56 183 10
Circle -7500403 true true 57 191 10
Polygon -7500403 true true 66 197 77 198 87 194 101 190 106 181 103 169 94 165 83 178 73 188 64 190
Polygon -7500403 true true 182 52 200 49 213 58 212 78 203 104 171 135 136 155 102 172 96 167 128 125 144 101 165 70
Polygon -7500403 true true 76 190 74 203 57 209 55 215 51 219 55 208 67 203 71 199 72 192
Polygon -7500403 true true 74 193 78 197 101 199 114 215 124 219 114 219 108 213 101 203 76 201
Polygon -7500403 true true 72 191 78 202 68 211 66 216 62 218 66 210 72 202 75 198 71 193

female-fly
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

fish 4
false
0
Polygon -7500403 true true 24 58 38 60 49 63 64 70 77 81 92 102 101 119 111 131 122 135 134 134 139 129 125 124 116 116 122 104 131 96 144 90 150 83 157 70 166 65 167 54 178 46 183 40 190 40 205 53 222 76 229 97 233 110 234 122 249 128 260 134 275 142 285 157 291 160 293 167 299 176 293 183 280 196 271 202 260 210 250 212 244 218 238 223 231 229 218 235 201 239 190 241 170 239 152 231 139 222 128 209 120 193 120 179 123 170 123 161 122 157 118 157 115 162 115 170 113 177 110 187 102 202 95 216 84 226 73 234 60 243 47 245 40 240 41 226 47 217 47 207 47 198 48 191 50 188 52 185 60 182 72 173 84 169 90 165 93 158 89 157 79 162 70 166 59 166 50 167 41 172 33 178 18 182 8 176 5 164 14 143 10 133 12 119 2 101 7 83 19 76 32 72 29 68 22 67 11 72 15 65
Polygon -7500403 true true 214 224 220 236 221 247 220 259 214 270 204 281 197 278 199 269 194 262 199 257 195 252 201 246 209 240 212 235 210 225
Polygon -16777216 true false 196 225 202 240 202 246 201 254 198 261 190 273 179 280 165 284 159 279 159 274 165 270 163 264 168 257 168 249 172 245 185 245 193 243 196 233
Polygon -7500403 true true 195 225 201 240 201 246 200 254 197 261 189 273 178 280 164 284 158 279 158 274 164 270 162 264 167 257 167 249 171 245 184 245 192 243 195 233
Circle -1 false false 273 159 12
Circle -16777216 true false 278 164 6

fish 5
false
0
Polygon -7500403 true true 0 144 15 120 30 105 75 75 106 66 150 45 184 37 210 45 195 60 180 75 210 105 225 135 240 135 255 105 270 90 285 75 270 120 265 137 264 152 265 168 270 180 285 225 270 210 255 195 240 165 225 165 210 195 180 225 210 255 182 262 150 255 108 235 75 225 30 195 15 180
Circle -1 false false 14 131 18
Circle -16777216 true false 15 137 10

fish 6
false
0
Polygon -7500403 true true 5 151 62 147 77 146 90 144 100 136 116 128 126 117 135 108 145 100 153 96 149 102 145 110 145 118 150 124 163 132 182 136 205 143 227 146 242 148 257 149 272 149 275 137 283 126 295 119 286 132 281 147 282 159 288 170 296 185 283 173 276 165 272 156 243 160 204 169 177 177 148 179 123 178 105 172 93 165 81 161 70 158 85 154
Polygon -7500403 true true 180 166 185 177 192 182 198 184 207 182 199 178 196 171 195 162 185 160
Polygon -7500403 true true 225 154 220 149 227 144 233 142 244 141 234 148 231 155 230 157 221 159
Polygon -7500403 true true 229 154 224 159 231 164 237 166 248 167 238 160 235 153 234 151 225 149
Circle -1 true false 97 142 4

fish 7
false
0
Polygon -7500403 true true 276 58 262 60 251 63 236 70 223 81 208 102 199 119 189 131 178 135 166 134 161 129 175 124 184 116 178 104 169 96 156 90 150 83 143 70 134 65 133 54 122 46 117 40 110 40 95 53 78 76 71 97 67 110 66 122 51 128 40 134 25 142 15 157 9 160 7 167 1 176 7 183 20 196 29 202 40 210 50 212 56 218 62 223 69 229 82 235 99 239 110 241 130 239 148 231 161 222 172 209 180 193 180 179 177 170 177 161 178 157 182 157 185 162 185 170 187 177 190 187 198 202 205 216 216 226 227 234 240 243 253 245 260 240 259 226 253 217 253 207 253 198 252 191 250 188 248 185 240 182 228 173 216 169 210 165 207 158 211 157 221 162 230 166 241 166 250 167 259 172 267 178 282 182 292 176 295 164 286 143 290 133 288 119 298 101 293 83 281 76 268 72 271 68 278 67 289 72 285 65
Polygon -7500403 true true 86 224 80 236 79 247 80 259 86 270 96 281 103 278 101 269 106 262 101 257 105 252 99 246 91 240 88 235 90 225
Polygon -16777216 true false 104 225 98 240 98 246 99 254 102 261 110 273 121 280 135 284 141 279 141 274 135 270 137 264 132 257 132 249 128 245 115 245 107 243 104 233
Polygon -7500403 true true 105 225 99 240 99 246 100 254 103 261 111 273 122 280 136 284 142 279 142 274 136 270 138 264 133 257 133 249 129 245 116 245 108 243 105 233
Circle -1 false false 15 159 12
Circle -16777216 true false 16 164 6

fish 8
true
0
Polygon -7500403 true true 242 276 240 262 237 251 230 236 219 223 198 208 181 199 169 189 165 178 166 166 171 161 176 175 184 184 196 178 204 169 210 156 217 150 230 143 235 134 246 133 254 122 260 117 260 110 247 95 224 78 203 71 190 67 178 66 172 51 166 40 158 25 143 15 140 9 133 7 124 1 117 7 104 20 98 29 90 40 88 50 82 56 77 62 71 69 65 82 61 99 59 110 61 130 69 148 78 161 91 172 107 180 121 180 130 177 139 177 143 178 143 182 138 185 130 185 123 187 113 190 98 198 84 205 74 216 66 227 57 240 55 253 60 260 74 259 83 253 93 253 102 253 109 252 112 250 115 248 118 240 127 228 131 216 135 210 142 207 143 211 138 221 134 230 134 241 133 250 128 259 122 267 118 282 124 292 136 295 157 286 167 290 181 288 199 298 217 293 224 281 228 268 232 271 233 278 228 289 235 285
Polygon -7500403 true true 76 86 64 80 53 79 41 80 30 86 19 96 22 103 31 101 38 106 43 101 48 105 54 99 60 91 65 88 75 90
Polygon -16777216 true false 75 104 60 98 54 98 46 99 39 102 27 110 20 121 16 135 21 141 26 141 30 135 36 137 43 132 51 132 55 128 55 115 57 107 67 104
Polygon -7500403 true true 75 105 60 99 54 99 46 100 39 103 27 111 20 122 16 136 21 142 26 142 30 136 36 138 43 133 51 133 55 129 55 116 57 108 67 105
Circle -1 false false 129 15 12
Circle -16777216 true false 130 16 6

fish 9
true
0
Polygon -7500403 true true 58 276 60 262 63 251 70 236 81 223 102 208 119 199 131 189 135 178 134 166 129 161 124 175 116 184 104 178 96 169 90 156 83 150 70 143 65 134 54 133 46 122 40 117 40 110 53 95 76 78 97 71 110 67 122 66 128 51 134 40 142 25 157 15 160 9 167 7 176 1 183 7 196 20 202 29 210 40 212 50 218 56 223 62 229 69 235 82 239 99 241 110 239 130 231 148 222 161 209 172 193 180 179 180 170 177 161 177 157 178 157 182 162 185 170 185 177 187 187 190 202 198 216 205 226 216 234 227 243 240 245 253 240 260 226 259 217 253 207 253 198 253 191 252 188 250 185 248 182 240 173 228 169 216 165 210 158 207 157 211 162 221 166 230 166 241 167 250 172 259 178 267 182 282 176 292 164 295 143 286 133 290 119 288 101 298 83 293 76 281 72 268 68 271 67 278 72 289 65 285
Polygon -7500403 true true 224 86 236 80 247 79 259 80 270 86 281 96 278 103 269 101 262 106 257 101 252 105 246 99 240 91 235 88 225 90
Polygon -16777216 true false 225 104 240 98 246 98 254 99 261 102 273 110 280 121 284 135 279 141 274 141 270 135 264 137 257 132 249 132 245 128 245 115 243 107 233 104
Polygon -7500403 true true 225 105 240 99 246 99 254 100 261 103 273 111 280 122 284 136 279 142 274 142 270 136 264 138 257 133 249 133 245 129 245 116 243 108 233 105
Circle -1 false false 159 15 12
Circle -16777216 true false 164 16 6

fish-l
false
0
Polygon -7500403 true true 25 59 39 61 50 64 65 71 78 82 93 103 102 120 112 132 123 136 135 135 140 130 126 125 117 117 123 105 132 97 145 91 151 84 158 71 167 66 168 55 179 47 184 41 191 41 206 54 223 77 230 98 234 111 235 123 250 129 261 135 276 143 286 158 292 161 294 168 300 177 294 184 281 197 272 203 261 211 251 213 245 219 239 224 232 230 219 236 202 240 191 242 171 240 153 232 140 223 129 210 121 194 121 180 124 171 124 162 123 158 119 158 116 163 116 171 114 178 111 188 103 203 96 217 85 227 74 235 61 244 48 246 41 241 42 227 48 218 48 208 48 199 49 192 51 189 53 186 61 183 73 174 85 170 91 166 94 159 90 158 80 163 71 167 60 167 51 168 42 173 34 179 19 183 9 177 6 165 15 144 11 134 13 120 3 102 8 84 20 77 33 73 30 69 23 68 12 73 16 66
Polygon -7500403 true true 214 224 220 236 221 247 220 259 214 270 204 281 197 278 199 269 194 262 199 257 195 252 201 246 209 240 212 235 210 225
Polygon -16777216 true false 196 225 202 240 202 246 201 254 198 261 190 273 179 280 165 284 159 279 159 274 165 270 163 264 168 257 168 249 172 245 185 245 193 243 196 233
Polygon -7500403 true true 195 225 201 240 201 246 200 254 197 261 189 273 178 280 164 284 158 279 158 274 164 270 162 264 167 257 167 249 171 245 184 245 192 243 195 233
Circle -1 false false 273 159 12
Circle -16777216 true false 278 164 6
Polygon -1 true false 38 74 52 79 71 90 85 111 99 130 105 137 95 128 75 104 64 92 52 84 35 79 24 77
Polygon -1 true false 28 98 44 102 63 113 74 126 86 135 99 140 87 139 67 124 56 112 40 104 27 102 8 100
Polygon -1 true false 35 129 51 133 62 139 72 145 80 149 94 151 81 152 67 145 57 139 47 135 34 133 15 131
Polygon -1 true false 23 167 39 160 57 158 67 159 76 159 56 155 42 157 29 160 14 172
Polygon -1 true false 106 167 99 189 92 201 82 212 68 226 50 236 57 230 66 225 78 213 87 202 96 190
Polygon -1 true false 177 61 194 69 202 76 208 88 213 100 217 117 209 93 199 75 186 67 174 62
Polygon -1 true false 163 76 180 84 188 91 193 100 199 115 200 122 193 105 185 90 172 82 160 77
Polygon -1 true false 152 99 161 103 172 113 177 119 178 122 171 115 163 107 155 103 149 98
Polygon -1 true false 138 210 151 221 164 230 181 234 193 236 179 232 164 224 147 209 138 199 130 195

fish-ll
false
0
Polygon -7500403 true true 25 59 39 61 50 64 65 71 78 82 93 103 102 120 112 132 123 136 135 135 140 130 126 125 117 117 123 105 132 97 145 91 151 84 158 71 167 66 168 55 179 47 184 41 191 41 206 54 223 77 230 98 234 111 235 123 250 129 261 135 276 143 286 158 292 161 294 168 300 177 294 184 281 197 272 203 261 211 251 213 245 219 239 224 232 230 219 236 202 240 191 242 171 240 153 232 140 223 129 210 121 194 121 180 124 171 124 162 123 158 119 158 116 163 116 171 114 178 111 188 103 203 96 217 85 227 74 235 61 244 48 246 41 241 42 227 48 218 48 208 48 199 49 192 51 189 53 186 61 183 73 174 85 170 91 166 94 159 90 158 80 163 71 167 60 167 51 168 42 173 34 179 19 183 9 177 6 165 15 144 11 134 13 120 3 102 8 84 20 77 33 73 30 69 23 68 12 73 16 66
Polygon -7500403 true true 214 224 220 236 221 247 220 259 214 270 204 281 197 278 199 269 194 262 199 257 195 252 201 246 209 240 212 235 210 225
Polygon -16777216 true false 196 225 202 240 202 246 201 254 198 261 190 273 179 280 165 284 159 279 159 274 165 270 163 264 168 257 168 249 172 245 185 245 193 243 196 233
Polygon -7500403 true true 195 225 201 240 201 246 200 254 197 261 189 273 178 280 164 284 158 279 158 274 164 270 162 264 167 257 167 249 171 245 184 245 192 243 195 233
Circle -1 false false 273 159 12
Circle -16777216 true false 278 164 6
Polygon -2064490 true false 38 74 52 79 71 90 85 111 99 130 105 137 95 128 75 104 64 92 52 84 35 79 24 77
Polygon -2064490 true false 35 116 51 120 70 131 77 139 87 144 102 147 84 146 72 137 63 130 47 122 34 120 15 118
Polygon -2064490 true false 23 167 39 160 57 158 67 159 76 159 56 155 42 157 29 160 14 172
Polygon -2064490 true false 106 167 99 189 92 201 82 212 68 226 50 236 57 230 66 225 78 213 87 202 96 190
Polygon -2064490 true false 169 73 186 81 194 88 199 97 203 106 203 119 199 102 191 87 178 79 166 74
Polygon -2064490 true false 156 93 165 97 176 107 181 113 182 116 175 109 167 101 159 97 153 92
Polygon -2064490 true false 138 210 151 221 164 230 181 234 193 236 179 232 164 224 147 209 138 199 130 195

fish-r
false
0
Polygon -7500403 true true 275 59 261 61 250 64 235 71 222 82 207 103 198 120 188 132 177 136 165 135 160 130 174 125 183 117 177 105 168 97 155 91 149 84 142 71 133 66 132 55 121 47 116 41 109 41 94 54 77 77 70 98 66 111 65 123 50 129 39 135 24 143 14 158 8 161 6 168 0 177 6 184 19 197 28 203 39 211 49 213 55 219 61 224 68 230 81 236 98 240 109 242 129 240 147 232 160 223 171 210 179 194 179 180 176 171 176 162 177 158 181 158 184 163 184 171 186 178 189 188 197 203 204 217 215 227 226 235 239 244 252 246 259 241 258 227 252 218 252 208 252 199 251 192 249 189 247 186 239 183 227 174 215 170 209 166 206 159 210 158 220 163 229 167 240 167 249 168 258 173 266 179 281 183 291 177 294 165 285 144 289 134 287 120 297 102 292 84 280 77 267 73 270 69 277 68 288 73 284 66
Polygon -7500403 true true 86 224 80 236 79 247 80 259 86 270 96 281 103 278 101 269 106 262 101 257 105 252 99 246 91 240 88 235 90 225
Polygon -16777216 true false 104 225 98 240 98 246 99 254 102 261 110 273 121 280 135 284 141 279 141 274 135 270 137 264 132 257 132 249 128 245 115 245 107 243 104 233
Polygon -7500403 true true 105 225 99 240 99 246 100 254 103 261 111 273 122 280 136 284 142 279 142 274 136 270 138 264 133 257 133 249 129 245 116 245 108 243 105 233
Circle -1 false false 15 159 12
Circle -16777216 true false 16 164 6
Polygon -1 true false 262 74 248 79 229 90 215 111 201 130 195 137 205 128 225 104 236 92 248 84 265 79 276 77
Polygon -1 true false 272 98 256 102 237 113 226 126 214 135 201 140 213 139 233 124 244 112 260 104 273 102 292 100
Polygon -1 true false 265 129 249 133 238 139 228 145 220 149 206 151 219 152 233 145 243 139 253 135 266 133 285 131
Polygon -1 true false 277 167 261 160 243 158 233 159 224 159 244 155 258 157 271 160 286 172
Polygon -1 true false 194 167 201 189 208 201 218 212 232 226 250 236 243 230 234 225 222 213 213 202 204 190
Polygon -1 true false 123 61 106 69 98 76 92 88 87 100 83 117 91 93 101 75 114 67 126 62
Polygon -1 true false 137 76 120 84 112 91 107 100 101 115 100 122 107 105 115 90 128 82 140 77
Polygon -1 true false 148 99 139 103 128 113 123 119 122 122 129 115 137 107 145 103 151 98
Polygon -1 true false 162 210 149 221 136 230 119 234 107 236 121 232 136 224 153 209 162 199 170 195

fish-rr
false
0
Polygon -7500403 true true 275 59 261 61 250 64 235 71 222 82 207 103 198 120 188 132 177 136 165 135 160 130 174 125 183 117 177 105 168 97 155 91 149 84 142 71 133 66 132 55 121 47 116 41 109 41 94 54 77 77 70 98 66 111 65 123 50 129 39 135 24 143 14 158 8 161 6 168 0 177 6 184 19 197 28 203 39 211 49 213 55 219 61 224 68 230 81 236 98 240 109 242 129 240 147 232 160 223 171 210 179 194 179 180 176 171 176 162 177 158 181 158 184 163 184 171 186 178 189 188 197 203 204 217 215 227 226 235 239 244 252 246 259 241 258 227 252 218 252 208 252 199 251 192 249 189 247 186 239 183 227 174 215 170 209 166 206 159 210 158 220 163 229 167 240 167 249 168 258 173 266 179 281 183 291 177 294 165 285 144 289 134 287 120 297 102 292 84 280 77 267 73 270 69 277 68 288 73 284 66
Polygon -7500403 true true 86 224 80 236 79 247 80 259 86 270 96 281 103 278 101 269 106 262 101 257 105 252 99 246 91 240 88 235 90 225
Polygon -16777216 true false 104 225 98 240 98 246 99 254 102 261 110 273 121 280 135 284 141 279 141 274 135 270 137 264 132 257 132 249 128 245 115 245 107 243 104 233
Polygon -7500403 true true 105 225 99 240 99 246 100 254 103 261 111 273 122 280 136 284 142 279 142 274 136 270 138 264 133 257 133 249 129 245 116 245 108 243 105 233
Circle -1 false false 15 159 12
Circle -16777216 true false 16 164 6
Polygon -2064490 true false 262 74 248 79 229 90 215 111 201 130 195 137 205 128 225 104 236 92 248 84 265 79 276 77
Polygon -2064490 true false 265 116 249 120 230 131 223 139 213 144 198 147 216 146 228 137 237 130 253 122 266 120 285 118
Polygon -2064490 true false 277 167 261 160 243 158 233 159 224 159 244 155 258 157 271 160 286 172
Polygon -2064490 true false 194 167 201 189 208 201 218 212 232 226 250 236 243 230 234 225 222 213 213 202 204 190
Polygon -2064490 true false 131 73 114 81 106 88 101 97 97 106 97 119 101 102 109 87 122 79 134 74
Polygon -2064490 true false 144 93 135 97 124 107 119 113 118 116 125 109 133 101 141 97 147 92
Polygon -2064490 true false 162 210 149 221 136 230 119 234 107 236 121 232 136 224 153 209 162 199 170 195

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

grasshopper
false
0
Polygon -7500403 true true 226 157 241 152 247 159 243 185 238 185 234 181 230 175 217 184 200 191 181 194 164 198 141 200 121 198 101 192 84 184 79 179 104 165 137 155 157 154 183 154 203 156 221 158 227 158
Polygon -7500403 true true 238 154 250 122 262 91 267 63 269 39 270 11 271 33 269 59 265 85 250 128 240 156
Polygon -7500403 true true 239 155 259 121 269 104 281 76 288 50 295 20 288 56 283 74 271 104 258 127 240 155
Polygon -7500403 true true 207 179 237 190 246 208 256 212 242 209 235 194 203 185
Polygon -7500403 true true 169 187 162 196 161 215 154 218 164 215 166 198 180 187
Polygon -7500403 true true 230 166 255 172 256 191 263 194 253 191 251 174 217 170
Polygon -7500403 true true 147 178 166 185 173 203 183 201 171 207 163 187 134 182
Polygon -7500403 true true 121 170 73 101 67 100 24 203 18 201 12 199 7 195 15 198 23 200 64 98 67 93 72 95 75 99 92 122 137 157
Polygon -7500403 true true 133 166 85 97 79 96 51 209 44 204 39 202 36 199 43 201 50 203 76 94 79 89 84 91 87 95 104 118 155 157

ladybug
true
0
Circle -16777216 true false 139 65 23
Polygon -7500403 true true 150 78 161 68 183 65 209 68 222 69 231 79 240 98 245 116 251 140 253 173 248 198 234 221 217 240 194 259 179 270 165 278 150 281
Polygon -7500403 true true 152 78 141 68 119 65 93 68 80 69 71 79 62 98 57 116 51 140 49 173 54 198 68 221 85 240 108 259 123 270 137 278 152 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -16777216 true false 185 91 196 104 191 120 173 127 161 122 159 104 165 94
Polygon -16777216 true false 117 91 106 104 111 120 129 127 141 122 143 104 137 94
Polygon -16777216 true false 200 160 215 175 208 200 185 207 164 211 164 175 174 159
Polygon -16777216 true false 182 246 194 237 200 229 190 229 182 235 174 239 172 247
Polygon -16777216 true false 100 160 85 175 92 200 115 207 136 211 136 175 126 159
Polygon -16777216 true false 118 246 106 237 100 229 110 229 118 235 126 239 128 247
Polygon -16777216 true false 227 100 226 89 220 78 213 78 211 85 214 92 220 102
Polygon -16777216 true false 73 100 74 89 80 78 87 78 89 85 86 92 80 102
Polygon -16777216 true false 243 163 245 153 241 143 235 143 238 151 239 158 239 166
Polygon -16777216 true false 57 163 55 153 59 143 65 143 62 151 61 158 61 166
Polygon -1 true false 145 70 157 70 161 57 151 62 141 58

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

leaf-1
true
0
Polygon -7500403 true true 153 3 164 5 157 33 155 60 154 99 151 98 152 60 154 22 156 9
Polygon -7500403 true true 152 96 139 81 116 64 89 54 64 55 50 58 42 56 49 66 52 84 66 97 93 108 116 106 137 102
Polygon -7500403 true true 153 99 166 84 189 67 216 57 241 58 255 61 263 59 256 69 253 87 239 100 212 111 188 112 167 107
Polygon -7500403 true true 153 100 193 120 238 135 269 149 284 161 284 179 275 200 277 211 265 208 249 214 233 219 218 215 208 198 202 184 194 166 178 141 165 125
Polygon -7500403 true true 151 97 109 113 64 128 33 142 18 154 18 172 27 193 25 204 37 201 53 207 69 212 84 208 94 191 100 177 108 159 124 134 137 118
Polygon -7500403 true true 152 96 138 126 120 169 109 199 101 219 94 238 94 251 97 260 106 276 129 282 142 284 148 288 152 299 156 285 166 279 180 276 201 266 207 249 206 230 195 201 170 150

male-fly
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107

moth
true
0
Polygon -16777216 true false 150 54 138 61 132 65 116 102 76 178 57 232 62 260 72 281 92 277 129 258 143 250 146 266 151 276 156 266 160 250 170 258 183 263 212 278 229 281 240 262 242 232 226 180 186 101 169 63 163 60
Polygon -7500403 true true 151 52 139 59 133 63 117 100 77 176 58 230 63 258 73 279 93 275 130 256 144 248 147 264 152 274 157 264 161 248 171 256 184 261 213 276 230 279 241 260 243 230 227 178 187 99 170 61 164 58
Circle -7500403 true true 141 35 18
Circle -7500403 true true 135 39 30
Polygon -7500403 true true 146 41 130 34 114 28 94 26 90 27 101 32 118 33 138 40
Polygon -7500403 true true 130 68 122 54 117 37 113 25 99 9 116 24 121 38 128 53 137 67
Polygon -7500403 true true 130 81 114 71 98 83 76 107 49 117 35 126 28 128 34 129 31 137 42 123 76 110 71 121 85 100 93 94 102 113 97 90 112 79 123 96
Polygon -7500403 true true 154 41 170 34 186 28 206 26 210 27 199 32 182 33 162 40
Polygon -7500403 true true 168 71 176 57 181 40 185 28 199 12 182 27 177 41 170 56 161 70
Polygon -7500403 true true 170 81 186 71 202 83 224 107 251 117 265 126 272 128 266 129 269 137 258 123 224 110 229 121 215 100 207 94 198 113 203 90 188 79 177 96

moth 1
true
0
Polygon -7500403 true true 158 147 173 150 203 150 238 152 245 157 242 167 237 172 230 185 213 190 191 187 177 178 163 162
Polygon -7500403 true true 138 144 107 120 70 101 26 90 13 93 12 103 23 124 51 146 81 155 109 156 137 152
Polygon -7500403 true true 162 144 193 120 230 101 274 90 287 93 288 103 277 124 249 146 219 155 191 156 163 152
Polygon -7500403 true true 151 127 151 139 151 154 151 169 151 194 151 209 151 224 151 246 145 240 143 232 140 219 136 205 132 174 129 146 134 137 150 128
Polygon -7500403 true true 148 128 148 140 148 155 148 170 148 195 148 210 148 225 150 245 154 241 156 233 159 220 163 206 167 175 170 147 165 138 149 129
Polygon -7500403 true true 135 124 146 119 155 119 165 125 161 134 150 140 138 133
Polygon -7500403 true true 142 147 127 150 97 150 62 152 55 157 58 167 63 172 70 185 87 190 109 187 123 178 137 162
Polygon -7500403 true true 144 121 137 105 143 125
Polygon -7500403 true true 156 121 163 105 157 125
Polygon -7500403 true true 143 140 128 127 120 110 115 98 116 96 121 108 128 122 132 129 143 136
Polygon -7500403 true true 157 140 172 127 180 110 185 98 184 96 179 108 172 122 168 129 157 136

pebble
false
0
Polygon -7500403 true true 45 150 30 135 30 105 45 90 75 75 105 60 165 45 210 45 240 60 270 90 285 120 285 135 255 165 210 180 150 180 90 165

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

tile log
false
0
Rectangle -7500403 true true 0 0 300 300
Line -16777216 false 0 30 45 15
Line -16777216 false 45 15 120 30
Line -16777216 false 120 30 180 45
Line -16777216 false 180 45 225 45
Line -16777216 false 225 45 165 60
Line -16777216 false 165 60 120 75
Line -16777216 false 120 75 30 60
Line -16777216 false 30 60 0 60
Line -16777216 false 300 30 270 45
Line -16777216 false 270 45 255 60
Line -16777216 false 255 60 300 60
Polygon -16777216 false false 15 120 90 90 136 95 210 75 270 90 300 120 270 150 195 165 150 150 60 150 30 135
Polygon -16777216 false false 63 134 166 135 230 142 270 120 210 105 116 120 88 122
Polygon -16777216 false false 22 45 84 53 144 49 50 31
Line -16777216 false 0 180 15 180
Line -16777216 false 15 180 105 195
Line -16777216 false 105 195 180 195
Line -16777216 false 225 210 165 225
Line -16777216 false 165 225 60 225
Line -16777216 false 60 225 0 210
Line -16777216 false 300 180 264 191
Line -16777216 false 255 225 300 210
Line -16777216 false 16 196 116 211
Line -16777216 false 180 300 105 285
Line -16777216 false 135 255 240 240
Line -16777216 false 240 240 300 255
Line -16777216 false 135 255 105 285
Line -16777216 false 180 0 240 15
Line -16777216 false 240 15 300 0
Line -16777216 false 0 300 45 285
Line -16777216 false 45 285 45 270
Line -16777216 false 45 270 0 255
Polygon -16777216 false false 150 270 225 300 300 285 228 264
Line -16777216 false 223 209 255 225
Line -16777216 false 179 196 227 183
Line -16777216 false 228 183 266 192

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

weed
false
0
Polygon -7500403 true true 150 300 240 255 270 195 285 135 225 195 210 225 195 255
Polygon -7500403 true true 165 60 195 105 195 135 195 180 180 210 195 240 150 300 180 240 165 195 165 165 165 135 180 105
Polygon -7500403 true true 30 165 60 255 120 285 150 300 105 255 75 195
Polygon -7500403 true true 150 0 105 60 120 105 105 150 120 195 105 240 150 300 135 240 150 195 135 150 150 105 135 60

wenzi
true
0
Polygon -7500403 true true 150 0 141 61 150 80 160 61 150 0
Polygon -7500403 true true 142 75 159 76 168 91 158 114 164 195 160 227 151 243 141 227 137 194 145 113 132 92
Polygon -7500403 true true 149 112 52 81 22 81 7 96 19 114 74 123 129 117
Polygon -7500403 true true 156 113 251 83 281 83 296 98 284 116 229 125 174 119
Circle -7500403 true true 133 61 17
Circle -7500403 true true 150 61 17
Line -16777216 false 140 65 135 73
Line -16777216 false 160 65 165 73
Line -7500403 true 142 105 105 90
Line -7500403 true 105 90 90 60
Line -7500403 true 162 104 195 90
Line -7500403 true 195 90 210 60
Line -7500403 true 140 103 93 132
Line -7500403 true 93 132 66 193
Line -7500403 true 142 113 106 160
Line -7500403 true 160 103 207 132
Line -7500403 true 207 132 234 193
Line -7500403 true 107 158 120 197
Line -7500403 true 120 198 87 277
Line -7500403 true 158 113 194 160
Line -7500403 true 193 158 180 197
Line -7500403 true 180 198 213 277

wenzi 1
true
0
Polygon -7500403 true true 150 0 141 61 150 80 160 61 150 0
Polygon -7500403 true true 142 75 159 76 168 91 158 114 164 195 160 227 151 243 141 227 137 194 145 113 132 92
Polygon -7500403 true true 149 112 52 81 22 81 7 96 19 114 74 123 129 117
Polygon -7500403 true true 156 113 251 83 281 83 296 98 284 116 229 125 174 119
Circle -7500403 true true 133 61 17
Circle -7500403 true true 150 61 17
Line -16777216 false 140 65 135 73
Line -16777216 false 160 65 165 73
Line -7500403 true 142 113 106 160
Line -7500403 true 107 158 120 197
Line -7500403 true 158 113 194 160
Line -7500403 true 193 158 180 197
Line -7500403 true 120 198 87 277
Line -7500403 true 180 198 213 277

wenzi 2
false
0
Circle -7500403 true true 191 170 20
Circle -7500403 true true 147 139 50
Polygon -7500403 true true 159 149 136 146 120 140 102 132 81 131 66 134 53 141 55 143 54 144 54 146 57 148 66 150 79 153 94 153 110 157 122 161 129 164 136 167 149 168 152 166
Polygon -7500403 true true 171 147 159 135 148 102 151 75 157 30 161 27 171 104 172 128
Polygon -7500403 true true 158 140 119 78 79 26 66 24 62 37 70 65 80 88 99 111 133 135 161 149
Polygon -7500403 true true 203 190 200 258 206 186
Line -7500403 true 176 186 223 142
Line -7500403 true 223 142 221 213
Line -7500403 true 221 214 266 242
Line -7500403 true 159 185 166 237
Line -7500403 true 166 238 188 259
Line -7500403 true 96 133 72 104
Line -7500403 true 93 152 54 182
Line -7500403 true 55 183 10 164
Line -7500403 true 72 106 21 179
Line -7500403 true 23 180 4 188

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

worm
false
0
Circle -7500403 true true 65 170 16
Circle -7500403 true true 52 178 16
Circle -7500403 true true 79 165 16
Circle -7500403 true true 93 163 16
Circle -7500403 true true 107 161 16
Circle -7500403 true true 121 162 16
Circle -7500403 true true 136 163 16
Circle -7500403 true true 149 165 16
Circle -7500403 true true 163 164 16
Circle -7500403 true true 177 161 16
Circle -7500403 true true 190 155 16
Circle -7500403 true true 201 149 16
Circle -7500403 true true 212 141 16
Circle -7500403 true true 223 133 16
Circle -7500403 true true 231 130 10
Circle -7500403 true true 216 132 16
Circle -7500403 true true 223 140 16
Circle -7500403 true true 216 149 16
Circle -7500403 true true 206 139 16
Circle -7500403 true true 206 157 16
Circle -7500403 true true 196 147 16
Circle -7500403 true true 193 163 16
Circle -7500403 true true 184 152 16
Circle -7500403 true true 180 164 16
Circle -7500403 true true 170 154 16
Circle -7500403 true true 156 155 16
Circle -7500403 true true 164 167 16
Circle -7500403 true true 143 155 16
Circle -7500403 true true 149 168 16
Circle -7500403 true true 129 156 16
Circle -7500403 true true 134 169 16
Circle -7500403 true true 114 156 16
Circle -7500403 true true 118 168 16
Circle -7500403 true true 101 158 16
Circle -7500403 true true 107 168 16
Circle -7500403 true true 88 160 16
Circle -7500403 true true 95 169 16
Circle -7500403 true true 82 170 16
Circle -7500403 true true 70 177 16
Circle -7500403 true true 59 184 16
Circle -7500403 true true 48 197 10
Circle -7500403 true true 50 187 16

worm 1
false
0
Polygon -7500403 true true 42 133 46 125 50 119 57 119 73 113 93 117 107 133 116 140 129 138 139 143 151 141 161 145 171 143 180 148 190 144 201 148 209 144 221 147 232 143 251 139 264 143 274 151 280 159 280 165 256 169 222 167 203 171 172 170 127 169 87 162 68 154 57 147 47 139 41 144
Polygon -7500403 true true 59 146 43 154 53 142
Polygon -7500403 true true 245 141 260 133 253 144
Polygon -7500403 true true 77 157 66 166 63 165 68 153
Polygon -7500403 true true 123 165 114 175 111 175 113 164
Polygon -7500403 true true 147 160 142 170 138 173 135 177 132 176 133 168 132 161
Polygon -7500403 true true 167 161 162 171 158 174 155 178 152 177 153 169 152 162
Polygon -7500403 true true 188 161 183 171 179 174 176 178 173 177 174 169 173 162
Polygon -7500403 true true 210 162 205 172 201 175 198 179 195 178 196 170 195 163
Polygon -7500403 true true 232 160 227 170 223 173 220 177 217 176 218 168 217 161
Polygon -7500403 true true 251 160 246 170 242 173 239 177 236 176 237 168 236 161
Polygon -7500403 true true 266 158 261 168 257 171 254 175 251 174 252 166 251 159
Polygon -7500403 true true 67 151 52 159 59 148
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
