;; 2 semicolon ha tozihat satr hastand (ghabel hazf hastand)
;; 1 semikolon ha dar barname taghyir ijad mikonad
breed [consumers consumer]

globals[
  pop-level-1
  pop-level-2
  pop-level-3
  TR
  sen-random

  temp-feature-D
  temp-price-D
  temp-promo-D
  temp-place-D

  temp-feature-F
  temp-price-F
  temp-promo-F
  temp-place-F
  s
]



consumers-own [
  ;social-level    ***************************************** be kar narafte ast
  price-sen
  feature-sen
  promo-sen
  SI-sen

  PRE-1
  PRE-2
  PRE
  buy-ok

  feature-index-D
  price-index-D
  promo-index-D
  SI-index-D
  feature-index-F
  price-index-F
  promo-index-F
  SI-index-F
  t  ;;reset buy-ok after 100 tick

  ;;social:
  adoptee-neighbors
  random-thresh
  p; change: exogenouce factors
  p1
  p2
  p3
  p4
  q; change: endogenouce factors

]

patches-own [
  feature-D
  price-D
  promo-D
  SI-D
  feature-F
  price-F
  promo-F
  SI-F

]

to setup
  clear-all
  goods ;;goods = patches
  setup-pa
  ;index
  ask consumers [
    set p1 random-normal 4 3 ;p1-mean p1-SD    ; entekhab adadi ba miangin p1-mean va enheraf meyar p1-SD
    set p2 random-normal 4 3 ;p2-mean p2-SD
    set p3 random-normal 4 3 ;p3-mean p3-SD
    set p4 random-normal 4 3 ;p4-mean p4-SD
    set p (p1 + p2 + p3 + p4) / 4 ] ; change p can be replaced by latent-thresh

  ask consumer random total-population [set color red]
  reset-ticks
end

to go
  if not any? consumers [ stop ]
  if ticks = maxticks [stop]
  change
  consumer-move
  social-interact
  ;;social:
  update-local-search
  decide-adopt
  index
  preferences
  tick
end


to consumer-move
   ask consumers [
    rt random 90
    lt random 90
    fd 1
   ]
end

to index
  ask consumers[
    if pcolor = blue [
      set feature-index-D feature-sen * battry-distance
      set price-index-D -1 * price-sen * charge-time
      set promo-index-D promo-sen * max-speed
      set SI-index-D SI-sen * charge-cost
                                                 set PRE-1 feature-index-D + price-index-D + promo-index-D + SI-index-D  ;si-sen baraye meghdar avaliye ast va badan SI-index  nashi az interact ezafe mishavad.
    ]
    if pcolor = yellow[
      ;Foreign
      set feature-index-F feature-sen * battry-distance2
      set price-index-F -1 * price-sen * charge-time2
      set promo-index-F promo-sen * max-speed2
      set SI-index-F SI-sen * charge-cost2
                                                 set PRE-2 feature-index-F + price-index-F + promo-index-F + SI-index-F
    ]
  set PRE max (list PRE-1 PRE-2)
  ]
end


to make-node [old-node]
  ;set-default-shape consumers "person"
  set total-population total-population
  set darsad-taxi-driver darsad-taxi-driver
  set darsad-employee darsad-employee
  set darsad-engineer darsad-engineer
  if (darsad-taxi-driver + darsad-employee + darsad-engineer) != 1[ show "error: population percent is not true"]
  set pop-level-1 darsad-taxi-driver * total-population
  set pop-level-2 darsad-employee * total-population
  set pop-level-3 darsad-engineer * total-population

  let clist []
  let c1 count consumers with [label = 1]
  let c2 count consumers with [label = 2]
  let c3 count consumers with [label = 3]

  if c1 <= pop-level-1 [set clist lput 1 clist ]
  if c2 <= pop-level-2 [set clist lput 2 clist]
  if c3 <= pop-level-2 [set clist lput 3 clist]

  if clist = [] [set clist lput 1 clist ]
  let c one-of clist


   if c = 1 [
   ;;level-1 Groups:
   create-consumers 1[
    set label 1
    setxy random-xcor random-ycor

    ;;;social;;;
    set color red
    if old-node != nobody
      [ create-link-with old-node [ set color green ]
        ;; position the new node near its partner
        move-to old-node
        fd 8
      ]
    ;;social;;

    set sen-random random-normal sen-batry1 0.065624    set feature-sen sen-random
    set sen-random random-normal sen-charget1 0.183302      set price-sen sen-random
    set sen-random random-normal sen-speed1 0.024031      set promo-sen sen-random
    set sen-random random-normal sen-chargCost1 0.083501         set SI-sen sen-random

    set PRE-1 feature-index-D + price-index-D + promo-index-D + SI-index-D
    set PRE-2 feature-index-F + price-index-F + promo-index-F + SI-index-F
    set buy-ok 0 set t 0 set size 0.75
   ]
   ]

   if c = 2 [
   ;;level-2 Groups:
   create-consumers 1 [
     set label 2
     setxy random-xcor random-ycor

      ;;;social;;;
    set color red
    if old-node != nobody
      [ create-link-with old-node [ set color green ]
        ;; position the new node near its partner
        move-to old-node
        fd 8
      ]
    ;;social;;

    set sen-random random-normal sen-batry2 0.026539  set feature-sen sen-random
    set sen-random random-normal sen-charget2 0.11829     set price-sen sen-random
    set sen-random random-normal sen-speed2 0.046191    set promo-sen sen-random
    set sen-random random-normal sen-chargCost2 0.149441       set SI-sen sen-random

    set PRE-1 feature-index-D + price-index-D + promo-index-D + SI-index-D
    set PRE-2 feature-index-F + price-index-F + promo-index-F + SI-index-F
    set buy-ok 0 set t 0 set size 0.75
   ]
   ]

   if c = 3 [
   ;;level-3 Groups:
   create-consumers 1 [
     set label 3
     setxy random-xcor random-ycor
     ;set color white - 5

      ;;;social;;;
    set color red
    if old-node != nobody
      [ create-link-with old-node [ set color green ]
        ;; position the new node near its partner
        move-to old-node
        fd 8
      ]
    ;;social;;

      set sen-random random-normal sen-batry3 0.021685  set feature-sen sen-random
      set sen-random random-normal sen-charget3 0.196543   set price-sen sen-random
      set sen-random random-normal sen-speed3 0.18422   set promo-sen sen-random
      set sen-random random-normal sen-chargCost3 0.044505      set SI-sen sen-random

      set PRE-1 feature-index-D + price-index-D + promo-index-D + SI-index-D
      set PRE-2 feature-index-F + price-index-F + promo-index-F + SI-index-F
      set buy-ok 0 set t 0 set size 0.75
   ]
   ]
   set c1 0  set c2 0 set c3 0 set clist []
   ;ask consumers [set buy-ok 0 set t 0 set size 0.75]
   ;ask consumer random total-population [set color red]  ;;social
end


to goods
  ask patches [
    set pcolor gray
    if random 100 < 3 and pcolor = gray [set pcolor blue ]     ;; 3 % khanehaye patch abi rang (Domestic) mishavand.
    if random 100 < 3 and pcolor = gray [set pcolor yellow ]  ;; 3 % khanehaye patch abi rang (Foreign) mishavand.
  ]
  ask patches [
    if pcolor = blue[
      ;Goods inputs
      ;;Domestic Goods
      set battry-distance battry-distance set temp-feature-D battry-distance
      set charge-time charge-time     set temp-price-D charge-time
      set max-speed max-speed     set temp-promo-D max-speed
      set charge-cost charge-cost     set temp-place-D charge-cost
    ]
    ;foreign Goods
    if pcolor = yellow [
      set battry-distance2 battry-distance2  set temp-feature-F battry-distance2
      set charge-time2 charge-time2      set temp-price-F charge-time2
      set max-speed2 max-speed2      set temp-promo-F max-speed2
      set charge-cost2 charge-cost2      set temp-place-F charge-cost2
    ]
  ]
end

to change
  ;;goods parameters change
  ask patches [
  if temp-feature-D != battry-distance [set battry-distance battry-distance  set temp-feature-D battry-distance   set s 1]
  if temp-price-D != charge-time     [set charge-time charge-time      set temp-price-D charge-time       set s 1]
  if temp-promo-D != max-speed     [set max-speed max-speed      set temp-promo-D max-speed       set s 1]
  if temp-place-D != charge-cost     [set charge-cost charge-cost      set temp-place-D charge-cost       set s 1]

  if temp-feature-F != battry-distance2 [set battry-distance2 battry-distance2 set temp-feature-F battry-distance2    set s 1]
  if temp-price-F != charge-time2     [set charge-time2 charge-time2     set temp-place-F charge-time2        set s 1]
  if temp-promo-F != max-speed2     [set max-speed2 max-speed2     set temp-promo-F max-speed2        set s 1]
  if temp-place-F != charge-cost2     [set charge-cost2 charge-cost2     set temp-place-F charge-cost2        set s 1]
  ]
end


to preferences
  ;SI-prosseces
  ask consumers [if buy-ok != 0 [set t t + 1]] ;if t = 50 [set buy-ok 0]]
  set TR random-normal adoption-threshold 0.1
  ask consumers [
    ;set TR random-normal adoption-threshold 1
    if s = 1 [
      change
      ask consumers [
        set PRE-1 feature-index-D + price-index-D + promo-index-D + SI-index-D
        set PRE-2 feature-index-F + price-index-F + promo-index-F + SI-index-F
        set PRE max(list PRE-1 PRE-2)
      ]
    ]

  ;]
  ;set TR adoption-threshold

  ;ask consumers [
    if buy-ok = 0[
      if pcolor = blue or pcolor = yellow [         ;;if moshtari rooye khaneyi (patch) bashad k kala hast.
        ifelse PRE-1 >= TR and PRE-2 >= TR [
          ;set PRE max (list PRE-1 PRE-2)
          ifelse PRE >= TR [
            if PRE = PRE-1 [set buy-ok 1 beep]
            if PRE = PRE-2 [set buy-ok 2 beep]
          ]
          [show "Error when PRE calculate" stop]
        ]
        [ ;;else
          if PRE-1 < TR and PRE-2 < TR [
            set buy-ok 0   ;set color white  ;;buy-ok : 2 for foreign , 1 for Domestic
          ]
          if  PRE-1 >= TR [                       ;;******** sath income ra be nahvi bayad vared konim va buy-ok ra sefr gharar dahim. sath income ra be mizan entezar dar amad (vam o ...) niz vabaste konam
            set buy-ok 1   ;set color yellow + 2
            beep
          ]
          if PRE-2 >= TR[
            set buy-ok 2   ;set color white
            beep
          ]
        ]
      ]
    ]
    ;if buy-ok != 0 [set t t + 1]
    ;if t = 50 [set buy-ok 0]
  ]
end



;;;;;;;;;;;;;;;;;;;;;
;;;Social Function;;;
;;;;;;;;;;;;;;;;;;;;;
to setup-pa
  ;set-default-shape consumers "person"
  ;; make the initial network of two consumers and an edge
  make-node nobody        ;; first node, unattached
  make-node consumer 0      ;; second node, attached to first node
  repeat total-population [ go-pa ]

  ask consumers [set color white]
  ask links [set color yellow]
  reset-ticks
  ask consumers [ set q count link-neighbors] ; change: calculating the degree of centrality of each node ask consumers [ set q count link....
end

to go-pa
  ask links [ set color yellow ]
  make-node find-partner         ;; find partner & use it as attachment
                                 ;; point for new node
  ;tick
  if layout? [layout-pa]
end

to-report find-partner
  let total random-float sum [count link-neighbors] of consumers
  let partner nobody
  ask consumers
  [
    let nc count link-neighbors
    ;; if there's no winner yet...
    if partner = nobody
    [
      ifelse nc > total
        [ set partner self ]
        [ set total total - nc ]
    ]
  ]
  report partner
end

to social-interact
  ask consumers [
    set PRE-1 PRE-1 - SI-index-D
    set PRE-2 PRE-2 - SI-index-F
  ]
  ask consumers with [ label = 1] [
    let SI-index-1 0
    ask link-neighbors with [label = 1] [ set SI-index-1 SI-index-1 + 0.4 * sen-chargCost1]
    ask link-neighbors with [label = 2] [ set SI-index-1 SI-index-1 + 0.5 * sen-chargCost2]
    ask link-neighbors with [label = 3] [ set SI-index-1 SI-index-1 + 0.1 * sen-chargCost3]

    set SI-index-D (SI-index-D + SI-index-1) / count link-neighbors * charge-cost
    set SI-index-F (SI-index-F + SI-index-1) / count link-neighbors * charge-cost2

    set PRE-1 PRE-1 + SI-index-D
    set PRE-2 PRE-2 + SI-index-F
  ]

;;;;;; label 2
  ask consumers with [ label = 2] [
    let SI-index-2 0
    ask link-neighbors with [label = 1] [ set SI-index-2 SI-index-2 + 0.3 * sen-chargCost1]
    ask link-neighbors with [label = 2] [ set SI-index-2 SI-index-2 + 0.4 * sen-chargCost2]
    ask link-neighbors with [label = 3] [ set SI-index-2 SI-index-2 + 0.3 * sen-chargCost3]

    set SI-index-D (SI-index-D + SI-index-2) / count link-neighbors * charge-cost
    set SI-index-F (SI-index-F + SI-index-2) / count link-neighbors * charge-cost2

    set PRE-1 PRE-1 + SI-index-D
    set PRE-2 PRE-2 + SI-index-F
  ]
;;;;;; label 3
  ask consumers with [ label = 3] [
    let SI-index-3 0
    ask link-neighbors with [label = 1] [ set SI-index-3 SI-index-3 + 0.1 * sen-chargCost1]
    ask link-neighbors with [label = 2] [ set SI-index-3 SI-index-3 + 0.3 * sen-chargCost2]
    ask link-neighbors with [label = 3] [ set SI-index-3 SI-index-3 + 0.6 * sen-chargCost3]

    set SI-index-D (SI-index-D + SI-index-3) / count link-neighbors * charge-cost
    set SI-index-F (SI-index-F + SI-index-3) / count link-neighbors * charge-cost2

    set PRE-1 PRE-1 + SI-index-D
    set PRE-2 PRE-2 + SI-index-F
  ]
end
;;;;;;;;;;;;;;
;;; Layout ;;;
;;;;;;;;;;;;;;
to layout
  if not layout? [ stop ]
  ;; the number 10 here is arbitrary; more repetitions slows down the
  ;; model, but too few gives poor layouts
  repeat 10 [
    do-layout
    display  ;; so we get smooth animation
  ]
end

to do-layout
  layout-spring (consumers with [any? link-neighbors]) links 0.4 6 1
end

;;;;;;;;;;;;;;
;;; Layout ;;;
;;;;;;;;;;;;;;

;; resize-nodes, change back and forth from size based on degree to a size of 1
to resize-nodes
  ifelse all? consumers [size <= 1]
  [
    ;; a node is a circle with diameter determined by
    ;; the SIZE variable; using SQRT makes the circle's
    ;; area proportional to its degree
    ask consumers [ set size sqrt count link-neighbors ]
  ]
  [
    ask consumers [ set size 1 ]
  ]
end

to layout-pa
  ;; the number 3 here is arbitrary; more repetitions slows down the
  ;; model, but too few gives poor layouts
  repeat 3 [
    ;; the more consumers we have to fit into the same amount of space,
    ;; the smaller the inputs to layout-spring we'll need to use
    let factor sqrt count consumers
    ;; numbers here are arbitrarily chosen for pleasing appearance
    layout-spring consumers links (1 / factor) (7 / factor) (1 / factor)
    display  ;; for smooth animation
  ]
  ;; don't bump the edges of the world
  let x-offset max [xcor] of consumers + min [xcor] of consumers
  let y-offset max [ycor] of consumers + min [ycor] of consumers
  ;; big jumps look funny, so only adjust a little each time
  set x-offset limit-magnitude x-offset 0.1
  set y-offset limit-magnitude y-offset 0.1
  ask consumers [ setxy (xcor - x-offset / 2) (ycor - y-offset / 2) ]
end

to-report limit-magnitude [number limit]
  if number > limit [ report limit ]
  if number < (- limit) [ report (- limit) ]
  report number
end



to update-local-search
  ask consumers [
    set adoptee-neighbors count link-neighbors with [color = red]
    ;set label adoptee-neighbors
    set label-color 45 - adoptee-neighbors ];green ]
end

to decide-adopt
  ;; adoption means to turn red
  ;; based on comparing a random number between 0 and 100 to the various effects
  ;; these effects, in total, must exceed the random num for diffusion to occur
  let nadopt count consumers with [color = red]
  ask consumers [
    ;set shape "person"
    if color = white [
      set random-thresh random 100
          if random-thresh < p + ( q * (nadopt / number-of-nodes ) ) + ( adoptee-neighbors * cohesion-effect ) [
    ;  if random-thresh < constant-effect + ( endogenous-effect * (nadopt / number-of-nodes ) ) + ( adoptee-neighbors * cohesion-effect ) [
           set color red
           set shape "person"]
      ;; adopt if random number (0-100) is lower than
      ;; constant hazard + proportion adopted * endogenous hazard
      ;; note, cohesion-fx doesn't seem to work yet
    ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
893
12
1330
450
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
15
16
78
49
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
105
16
214
49
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
369
12
541
45
MaxTicks
MaxTicks
0
1000
200.0
1
1
NIL
HORIZONTAL

SLIDER
370
50
542
83
total-population
total-population
0
1000
159.0
1
1
NIL
HORIZONTAL

SLIDER
369
91
541
124
adoption-threshold
adoption-threshold
0
1.5
0.53
0.01
1
NIL
HORIZONTAL

SLIDER
6
278
116
311
sen-batry1
sen-batry1
0
1
0.46
0.01
1
NIL
HORIZONTAL

SLIDER
6
317
117
350
sen-charget1
sen-charget1
0
1
0.18
0.01
1
NIL
HORIZONTAL

SLIDER
6
353
118
386
sen-speed1
sen-speed1
0
1
0.08
0.01
1
NIL
HORIZONTAL

SLIDER
5
391
119
424
sen-chargCost1
sen-chargCost1
0
1
0.26
0.01
1
NIL
HORIZONTAL

SLIDER
129
280
238
313
sen-batry2
sen-batry2
0
1
0.32
0.01
1
NIL
HORIZONTAL

SLIDER
130
316
238
349
sen-charget2
sen-charget2
0
1
0.12
0.01
1
NIL
HORIZONTAL

SLIDER
129
353
239
386
sen-speed2
sen-speed2
0
1
0.11
0.01
1
NIL
HORIZONTAL

SLIDER
129
390
240
423
sen-chargCost2
sen-chargCost2
0
1
0.44
0.01
1
NIL
HORIZONTAL

TEXTBOX
10
258
91
276
taxi-driver
11
0.0
1

TEXTBOX
141
262
219
280
employee
11
0.0
1

TEXTBOX
15
244
476
272
-----------------------------------------------------------------------------------------------------------------
11
0.0
1

TEXTBOX
137
233
206
251
Social-Level
11
0.0
1

TEXTBOX
692
234
750
252
Car
11
0.0
1

TEXTBOX
561
244
864
272
---------------------------------------------------------------------
11
0.0
1

SLIDER
557
280
686
313
battry-distance
battry-distance
0
1
0.56
0.01
1
NIL
HORIZONTAL

SLIDER
557
315
685
348
charge-time
charge-time
0
1
0.7
0.01
1
NIL
HORIZONTAL

SLIDER
557
352
684
385
max-speed
max-speed
0
1
0.61
0.01
1
NIL
HORIZONTAL

SLIDER
557
389
683
422
charge-cost
charge-cost
0
1
0.57
0.01
1
NIL
HORIZONTAL

SLIDER
712
279
843
312
battry-distance2
battry-distance2
0
1
0.67
0.01
1
NIL
HORIZONTAL

SLIDER
711
316
842
349
charge-time2
charge-time2
0
1
0.7
0.01
1
NIL
HORIZONTAL

SLIDER
711
354
843
387
max-speed2
max-speed2
0
1
0.67
0.01
1
NIL
HORIZONTAL

SLIDER
712
390
845
423
charge-cost2
charge-cost2
0
1
0.62
0.01
1
NIL
HORIZONTAL

TEXTBOX
559
255
649
273
Type 1
11
0.0
1

TEXTBOX
758
257
818
275
Type 2
11
0.0
1

SLIDER
16
79
151
112
darsad-taxi-driver
darsad-taxi-driver
0
1
0.58
0.01
1
NIL
HORIZONTAL

PLOT
552
25
890
194
plot 1
Time
Preferences
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Taxi deiver" 1.0 0 -10141563 true "" "plot count consumers with [buy-ok = 1]"
"employee" 1.0 0 -2674135 true "" "plot count consumers with [buy-ok = 2]"
"enineer" 1.0 0 -7500403 true "" "plot count consumers with [buy-ok = 3] ;or color != yellow + 2 or color != green]"
"free" 1.0 0 -955883 true "" "plot count consumers with [buy-ok = 4]"
"NoPreferences" 1.0 0 -6459832 true "" "plot count consumers with [buy-ok = 0] ;or color != yellow + 2 or color != green]"

SLIDER
16
116
152
149
darsad-employee
darsad-employee
0
1
0.26
0.01
1
NIL
HORIZONTAL

SLIDER
15
154
153
187
darsad-engineer
darsad-engineer
0
1
0.17
0.01
1
NIL
HORIZONTAL

SLIDER
249
281
358
314
sen-batry3
sen-batry3
0
1
0.65
0.01
1
NIL
HORIZONTAL

SLIDER
248
317
359
350
sen-charget3
sen-charget3
0
1
0.08
0.01
1
NIL
HORIZONTAL

SLIDER
248
353
359
386
sen-speed3
sen-speed3
0
1
0.05
0.01
1
NIL
HORIZONTAL

SLIDER
249
389
359
422
sen-chargCost3
sen-chargCost3
0
1
0.2
0.01
1
NIL
HORIZONTAL

TEXTBOX
278
259
337
277
engineer
11
0.0
1

MONITOR
759
518
884
563
Type 2  Preferences
count consumers with [ buy-ok = 2]
3
1
11

MONITOR
511
520
649
565
Type 1  Preferences
count consumers with [ buy-ok = 1]
3
1
11

SLIDER
1154
482
1326
515
number-of-nodes
number-of-nodes
0
40
1.0
1
1
NIL
HORIZONTAL

SLIDER
979
480
1151
513
cohesion-effect
cohesion-effect
0
10
1.0
1
1
NIL
HORIZONTAL

MONITOR
668
519
740
564
NoPreferences
count consumers with [buy-ok = 0]
17
1
11

SWITCH
1113
528
1222
561
layout?
layout?
0
1
-1000

MONITOR
173
88
243
133
taxi deivers
count consumers with [label = 1]
17
1
11

MONITOR
249
89
320
134
employee
count consumers with [label = 2]
17
1
11

MONITOR
173
144
245
189
engineer
count consumers with [label = 3]
17
1
11

SLIDER
557
429
685
462
gov-stimulate
gov-stimulate
0
1
0.46
0.01
1
NIL
HORIZONTAL

SLIDER
557
470
686
503
price1
price1
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
712
430
848
463
gov-stimulate2
gov-stimulate2
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
713
473
848
506
price2
price2
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
368
282
480
315
sen-batry4
sen-batry4
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
367
319
479
352
sen-charget4
sen-charget4
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
368
354
480
387
sen-speed4
sen-speed4
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
368
389
480
422
sen-chargCost4
sen-chargCost4
0
1
0.5
0.01
1
NIL
HORIZONTAL

TEXTBOX
410
258
462
276
free
11
0.0
1

SLIDER
15
190
154
223
dasad-free
dasad-free
0
1
0.0
0.01
1
NIL
HORIZONTAL

MONITOR
249
144
321
189
free
count consumers with [label = 4]
17
1
11

SLIDER
6
430
120
463
sen-gs1
sen-gs1
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
130
431
240
464
sen-gs2
sen-gs2
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
247
431
360
464
sen-gs3
sen-gs3
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
369
431
480
464
sen-gs4
sen-gs4
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
6
472
119
505
sen-price1
sen-price1
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
126
472
239
505
sen-price2
sen-price2
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
247
470
361
503
sen-price1
sen-price1
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
367
473
481
506
sen-price4
sen-price4
0
1
0.5
0.01
1
NIL
HORIZONTAL

@#$#@#$#@
## Problems:
2. After consumer color change to red programm is stoped. We need continue for always.

## WHAT IS IT?



**Consumer prefrences Modeling With Agent Base**


## HOW IT WORKS


**Patch** : blue patches are Domestic goods
	yellow patches are Foreign goods

**consumers**: 
	   buy-ok = 0   -->    not preferences
	   buy-ok = 1   -->   Choise Domestic good
	   buy-ok = 2   -->   choise Foreign good

************
**preferences culclusion:**
1. set a adoption threshold from user (TR)
  
1. culculate PRE (preferences) = sum index (feature, price, promotion,social-influence) any index =  sensivity * range   (for all consumers is randomaly).

2.if PRE >= TR  choise one of goods.
  
  else not-preferences.


3. after 50 tick reset consumer choise.

************
**Social-Influence processes:**

consumers interact with other consumers and get influence.

	for example consumer level-1 when interact with:
		other level-1 consumer with level-1, get 0.4 influence
		other level-1 consumer with level-2, get 0.5 influence
		other level-1 consumer with level-3, get 0.1 influence
********
**SW for social porocesses**
-only changed from original program turtle(s)  --> consumer(s)

- some change on decide-adopt (end of program):

 1. color = red  --> buy-ok =1 ,2.

 2. p (random-normal)    --> sensivity from level of consumers.

 3. I changed culclution for each level. and change shape to "sheep".



## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
