breed [prey a-prey]
breed [predators predator]

turtles-own [speed hit erg]
predators-own[keen]

globals[prey-mean-speed predator-mean-speed slowest-prey-speed slowest-predator-speed]

;------
to setup
  ca

  setup-prey
  setup-predators
  setup-habitat
  do-plotting
  do-plotting-1

  reset-ticks
end

to prey-traits
  if species = "Shark-fish"
  [ set color 84
    set shape "fish"
    set size 1.25]


  if species = "Falcon-duck"
    [ set color 36
    set shape "bird side"
    set size 1.25]



  if species = "Wolf-elk"
    [set color 22
    set shape "elk"
    set size 2.25]

end

to predator-traits

    if species = "Shark-fish"
   [set color 2
    set size 4
    set shape "shark"]


  if species = "Falcon-duck"
    [ set color 33
    set shape "hawk"
    set size 2.5]

    if species = "Wolf-elk"
    [set color 0
    set shape "wolf"
    set size 1.25]

end

to set-speed
  if species = "Shark-fish"
    [ set speed 1 + random-float 1]

   if species = "Falcon-duck"
  [ set speed 9 + random-float 1]


   if species = "Wolf-elk"
    [set speed 3 + random-float 1]
end

to setup-prey
  create-prey Number-of-Prey
  [prey-traits
    set-speed
    setxy random-xcor random-ycor]
end

to setup-predators
  create-predators Number-of-Predators
  [predator-traits
    set hit 0
    set-speed
    setxy random-xcor random-ycor]
end

to setup-habitat
 ask patches
  [if species = "Shark-fish"
    [ set pcolor 105]

   if species = "Falcon-duck"
  [ set pcolor 88]


   if species = "Wolf-elk"
    [set pcolor green]
  ]
end

;------------

to go
  if years = 0 [user-message "input the years"]
  if ticks >= years [stop]

  setup-habitat
  ask prey [prey-traits]
  ask predators [predator-traits]

  move
  predation
  predator-death

  if count prey = 0 [user-message "There is no prey." stop ]
  if count predators = 0 [user-message "There is no predator." stop ]

  reproduction
  energy-back
  do-plotting
  do-plotting-1

  tick
end

to move
  ask turtles
  [rt random 45 lt random 45  fd 1]
end

to predation
  ask predators [
    set hit 0
    ifelse spot-the-slowest-prey?
    [repeat 5 [
        let meal one-of prey with [speed = min [speed] of prey]
              if meal != nobody
                 [if [speed] of meal < [speed] of self
                    [ set hit hit + 1
                     ask meal [die] ]
  ]]]
    [repeat 5 [
        let meal one-of prey
              if meal != nobody
                 [if [speed] of meal < [speed] of self
                    [ set hit hit + 1
                     ask meal [die] ]
  ]]]
  ]
end


to predation-1
  ask predators [
    set hit 0
    ifelse spot-the-slowest-prey?
    [repeat 5 [
        let possible-meal prey in-radius 10   ;Given the radius, the predator only hunts a subgroup of the population. This allows some slow prey survive at some point.
         if possible-meal != nobody [
        let meal one-of prey with [speed = min [speed] of possible-meal]
              if meal != nobody
                 [if [speed] of meal < [speed] of self
                    [ set hit hit + 1
                     ask meal [die] ]
  ]]]]
    [repeat 5 [
        let meal one-of prey in-radius 10
              if meal != nobody
                 [if [speed] of meal < [speed] of self
                    [ set hit hit + 1
                     ask meal [die] ]
  ]]]
  ]
end

to predator-death
  ask predators with [hit < 3] [die]

end

to reproduction
  set prey-mean-speed mean [speed] of prey
  set predator-mean-speed mean [speed] of predators

  create-prey Number-of-Prey - count prey
   [prey-traits
    ifelse random 2 = 0 [set speed prey-mean-speed + random-float Prey-speed-mutation][set speed prey-mean-speed - random-float Prey-speed-mutation]
    setxy random-xcor random-ycor]

  create-predators Number-of-Predators - count predators
   [predator-traits
    ifelse random 2 = 0 [set speed predator-mean-speed + random-float Predator-speed-mutation][set speed predator-mean-speed - random-float Predator-speed-mutation]
    setxy random-xcor random-ycor]

end

to energy-back      ;This procedure is not in use.

  ask patches [if pcolor = 0
    [if species = "Shark-fish"
    [ set pcolor 105]

   if species = "Falcon-duck"
  [ set pcolor 88]


   if species = "Wolf-elk"
    [set pcolor green]
    ]
  ]
end


to add-fast-prey
      create-prey 1
      [setxy random-xcor random-ycor
        prey-traits
        set speed max [speed] of prey + random-float 0.5]
end

to add-slow-prey
  set slowest-prey-speed min [speed] of prey
  if slowest-prey-speed <= 0 [user-message "Have reached the slowest speed" stop]
      create-prey 1
      [setxy random-xcor random-ycor
        prey-traits
        set speed slowest-prey-speed - random-float 0.3
    ]

end

to add-fast-predator
      create-predators 1
      [setxy random-xcor random-ycor
        predator-traits
        set speed max [speed] of predators + random-float 0.5]
end

to add-slow-predator
  set slowest-predator-speed min [speed] of predators
  if slowest-predator-speed <= 0 [user-message "Have reached the slowest speed" stop]
      create-predators 1
      [setxy random-xcor random-ycor
        predator-traits
        set speed slowest-predator-speed - random-float 0.3]
end

to do-plotting
set-current-plot "Prey Speed Distribution"
  set-plot-x-range (round min [speed] of turtles - 1) (round max [speed] of turtles + 1)
  histogram [speed] of prey
end

to do-plotting-1
set-current-plot "Predator Speed Distribution"
  set-plot-x-range (round min [speed] of turtles - 1) (round max [speed] of turtles + 1)
  histogram [speed] of predators
end
@#$#@#$#@
GRAPHICS-WINDOW
10
10
447
578
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-21
21
0
0
1
ticks
40.0

BUTTON
897
10
1029
62
Set/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
897
64
1029
106
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
455
291
745
577
Average Speeds of Predators and Prey
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Prey" 1.0 0 -13345367 true "plot mean [speed] of prey" "plot mean [speed] of prey"
"Predator" 1.0 0 -955883 true "plot mean [speed] of predators" "plot mean [speed] of predators"

MONITOR
549
205
665
246
Avg Predator Speed
mean [speed] of predators
2
1
10

MONITOR
549
248
665
289
Avg Prey Speed
mean [speed] of prey
2
1
10

BUTTON
755
10
893
43
Add a faster prey
add-fast-prey\ndo-plotting\ndo-plotting-1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
755
47
894
80
Add a slower prey
add-slow-prey\ndo-plotting\ndo-plotting-1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
748
202
1040
383
Prey Speed Distribution
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.1 1 -13345367 true "histogram [speed] of prey" "histogram [speed] of prey"

PLOT
748
385
1040
577
Predator Speed Distribution
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.1 1 -955883 true "histogram [speed] of predators" "histogram [speed] of predators"

INPUTBOX
452
57
557
117
Years
10000.0
1
0
Number

MONITOR
669
247
746
288
Years
ticks
17
1
10

MONITOR
455
205
548
246
# of Predators
count predators
17
1
10

SLIDER
560
83
749
116
Prey-speed-mutation
Prey-speed-mutation
0
0.5
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
560
120
749
153
Predator-speed-mutation
Predator-speed-mutation
0
0.5
0.1
0.1
1
NIL
HORIZONTAL

BUTTON
755
83
894
116
Add a faster predator
add-fast-predator\ndo-plotting\ndo-plotting-1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
755
119
894
152
Add a slower predator
add-slow-predator\ndo-plotting\ndo-plotting-1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
897
108
1029
153
Run a year
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

CHOOSER
452
10
557
55
Species
Species
"Shark-fish" "Falcon-duck" "Wolf-elk"
0

SWITCH
560
157
749
190
Spot-the-slowest-prey?
Spot-the-slowest-prey?
0
1
-1000

SLIDER
560
46
749
79
Number-of-Predators
Number-of-Predators
20
50
20.0
5
1
NIL
HORIZONTAL

SLIDER
560
10
749
43
Number-of-Prey
Number-of-Prey
100
300
100.0
1
1
NIL
HORIZONTAL

MONITOR
455
247
547
288
# of Prey
count prey
0
1
10

@#$#@#$#@
## WHAT IS IT?

This model simulates the process of coevolution. 

## HOW IT WORKS
<p>
1. There are prey and predator populations in the model. The population size can be adjusted by the "number-of-prey" and "number-of-predators" sliders. Once the user sets up the population sizes, they remain stable over time. There are three pairs of predator-prey relationships to try.
<p>
2. Each predator will hunt five times each tick. It has to get two successful hunts to survive. In each hunt, users may or may not allow the predators to identify the slowest prey in their hunting range. When "spot-the-slowest-prey" is off, the predator randomly picks one prey. It kills the prey if its speed is higher than that of the prey. When "spot-the-slowest-prey" is on, the predator picks the slowest prey. It kills the prey if its speed is higher than that of this prey.
<p>
3. The prey only dies when it is preyed on by the predators.
<p>
4. In each tick, both populations are re-established based on the survivors. The speed of new prey and predators are around the average speed of the survivors, with some variations determined by the relevant speed mutation. 
<p>
5. Mutation of speed for prey or predator can be controlled by the relevant sliders. Note it does not determine the mutation direction but only represents the extent to which the offspring can mutate. So the mutation can lead to either a faster or a slower runner. 
<p>
6. Users may add faster or slow prey/predators into the simulation, which are either slower or faster than the min/max speed of the existing prey/predators. 
<p>
7. This simulation does not consider the energy cost of prey or predators. The hunting success is solely determined by speed difference.

## HOW TO USE IT

* Press on "set/reset" to set the simulation. 
* Press on "run/pause" to run or pause the simulation.
* Sliders can be adjusted before and while running the simulation.

## THINGS TO TRY

* Alter the speed mutation of prey and predator to observe the results.
* Turn on and off predator's ability to spot the slowest prey.

## CREDITS AND REFERENCES

This model is made by Dr. Lin Xiang at Weber State University. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2018). Coevolution. Department of Zoology, Weber State University, Ogden, UT.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bird side
false
0
Polygon -7500403 true true 0 120 45 90 75 90 105 120 150 120 240 135 285 120 285 135 300 150 240 150 195 165 255 195 210 195 150 210 90 195 60 180 45 135
Circle -16777216 true false 38 98 14

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

elk
false
0
Polygon -7500403 true true 202 72 197 65 201 56 201 47 196 36 197 48 197 53 196 60 195 62 190 62 187 55 185 49 187 50 183 45 182 41 178 28 170 23 175 30 177 41 179 49 183 54 185 60 173 52 161 46 155 36 153 24 150 10 147 1 149 17 149 23 151 36 154 46 163 51 152 49 142 43 134 42 148 51 158 54 168 56 173 58 182 62 192 68 196 71 200 77 203 77 209 77
Polygon -7500403 true true 222 73 227 66 223 57 223 48 228 37 227 49 227 54 228 61 229 63 234 63 237 56 239 50 237 51 241 46 242 42 246 29 254 24 249 31 247 42 245 50 241 55 239 61 251 53 263 47 269 37 271 25 274 11 277 2 275 18 275 24 273 37 270 47 261 52 272 50 282 44 290 43 276 52 266 55 256 57 248 59 239 66 233 68 228 72 224 78 221 78 215 78
Polygon -7500403 true true 193 90 194 83 197 77 203 70 214 67 225 70 232 78 233 85 234 97 231 110 227 124 223 140 222 154 219 168 215 179 199 196 200 190 192 202 180 210 157 209 127 204 67 188 44 180 30 163 24 145 20 148 23 136 34 120 47 111 64 106 88 105 105 104 119 108 135 113 149 120 161 131 176 139 187 129 193 117 194 107 193 97
Polygon -7500403 true true 202 82 198 77 190 72 183 66 176 65 170 65 163 64 166 74 173 83 180 85 188 85 195 83 199 83
Polygon -7500403 true true 223 82 227 77 235 72 242 66 249 65 255 65 262 64 259 74 252 83 245 85 237 85 230 83 226 83
Polygon -7500403 true true 178 202 184 224 190 242 193 258 195 271 200 284 207 291 213 294 215 298 206 299 196 299 197 294 194 288 191 279 187 264 182 251 179 244 170 236 155 217 151 205
Polygon -7500403 true true 169 225 162 245 158 252 149 270 146 286 144 293 147 298 138 299 134 293 139 281 147 260 152 238 152 205 166 197
Polygon -7500403 true true 36 164 41 194 39 210 25 225 33 261 35 284 33 293 37 298 47 299 44 290 42 258 40 233 62 216 80 184
Polygon -7500403 true true 69 165 74 195 59 204 56 232 66 262 68 285 66 294 70 299 80 300 77 291 75 259 73 234 79 212 106 189

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

fish 2
false
0
Polygon -1 true false 56 133 34 127 12 105 21 126 23 146 16 163 10 194 32 177 55 173
Polygon -7500403 true true 156 229 118 242 67 248 37 248 51 222 49 168
Polygon -7500403 true true 30 60 45 75 60 105 50 136 150 53 89 56
Polygon -7500403 true true 50 132 146 52 241 72 268 119 291 147 271 156 291 164 264 208 211 239 148 231 48 177
Circle -1 true false 237 116 30
Circle -16777216 true false 241 127 12
Polygon -1 true false 159 228 160 294 182 281 206 236
Polygon -7500403 true true 102 189 109 203
Polygon -1 true false 215 182 181 192 171 177 169 164 152 142 154 123 170 119 223 163
Line -16777216 false 240 77 162 71
Line -16777216 false 164 71 98 78
Line -16777216 false 96 79 62 105
Line -16777216 false 50 179 88 217
Line -16777216 false 88 217 149 230

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

hawk
true
0
Polygon -7500403 true true 151 170 136 170 123 229 143 244 156 244 179 229 166 170
Polygon -16777216 true false 152 154 137 154 125 213 140 229 159 229 179 214 167 154
Polygon -7500403 true true 151 140 136 140 126 202 139 214 159 214 176 200 166 140
Polygon -16777216 true false 151 125 134 124 128 188 140 198 161 197 174 188 166 125
Polygon -7500403 true true 152 86 227 72 286 97 272 101 294 117 276 118 287 131 270 131 278 141 264 138 267 145 228 150 153 147
Polygon -7500403 true true 160 74 159 61 149 54 130 53 139 62 133 81 127 113 129 149 134 177 150 206 168 179 172 147 169 111
Circle -16777216 true false 144 55 7
Polygon -16777216 true false 129 53 135 58 139 54
Polygon -7500403 true true 148 86 73 72 14 97 28 101 6 117 24 118 13 131 30 131 22 141 36 138 33 145 72 150 147 147

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

rabbit
false
0
Polygon -7500403 true true 61 150 76 180 91 195 103 214 91 240 76 255 61 270 76 270 106 255 132 209 151 210 181 210 211 240 196 255 181 255 166 247 151 255 166 270 211 270 241 255 240 210 270 225 285 165 256 135 226 105 166 90 91 105
Polygon -7500403 true true 75 164 94 104 70 82 45 89 19 104 4 149 19 164 37 162 59 153
Polygon -7500403 true true 64 98 96 87 138 26 130 15 97 36 54 86
Polygon -7500403 true true 49 89 57 47 78 4 89 20 70 88
Circle -16777216 true false 37 103 16
Line -16777216 false 44 150 104 150
Line -16777216 false 39 158 84 175
Line -16777216 false 29 159 57 195
Polygon -5825686 true false 0 150 15 165 15 150
Polygon -5825686 true false 76 90 97 47 130 32
Line -16777216 false 180 210 165 180
Line -16777216 false 165 180 180 165
Line -16777216 false 180 165 225 165
Line -16777216 false 180 210 210 240

shark
false
0
Polygon -7500403 true true 283 153 288 149 271 146 301 145 300 138 247 119 190 107 104 117 54 133 39 134 10 99 9 112 19 142 9 175 10 185 40 158 69 154 64 164 80 161 86 156 132 160 209 164
Polygon -7500403 true true 199 161 152 166 137 164 169 154
Polygon -7500403 true true 188 108 172 83 160 74 156 76 159 97 153 112
Circle -16777216 true false 256 129 12
Line -16777216 false 222 134 222 150
Line -16777216 false 217 134 217 150
Line -16777216 false 212 134 212 150
Polygon -7500403 true true 78 125 62 118 63 130
Polygon -7500403 true true 121 157 105 161 101 156 106 152

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

sheep 2
false
0
Polygon -7500403 true true 209 183 194 198 179 198 164 183 164 174 149 183 89 183 74 168 59 198 44 198 29 185 43 151 28 121 44 91 59 80 89 80 164 95 194 80 254 65 269 80 284 125 269 140 239 125 224 153 209 168
Rectangle -7500403 true true 180 195 195 225
Rectangle -7500403 true true 45 195 60 225
Rectangle -16777216 true false 180 225 195 240
Rectangle -16777216 true false 45 225 60 240
Polygon -7500403 true true 245 60 250 72 240 78 225 63 230 51
Polygon -7500403 true true 25 72 40 80 42 98 22 91
Line -16777216 false 270 137 251 122
Line -16777216 false 266 90 254 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

squirrel
false
0
Polygon -7500403 true true 87 267 106 290 145 292 157 288 175 292 209 292 207 281 190 276 174 277 156 271 154 261 157 245 151 230 156 221 171 209 214 165 231 171 239 171 263 154 281 137 294 136 297 126 295 119 279 117 241 145 242 128 262 132 282 124 288 108 269 88 247 73 226 72 213 76 208 88 190 112 151 107 119 117 84 139 61 175 57 210 65 231 79 253 65 243 46 187 49 157 82 109 115 93 146 83 202 49 231 13 181 12 142 6 95 30 50 39 12 96 0 162 23 250 68 275
Polygon -16777216 true false 237 85 249 84 255 92 246 95
Line -16777216 false 221 82 213 93
Line -16777216 false 253 119 266 124
Line -16777216 false 278 110 278 116
Line -16777216 false 149 229 135 211
Line -16777216 false 134 211 115 207
Line -16777216 false 117 207 106 211
Line -16777216 false 91 268 131 290
Line -16777216 false 220 82 213 79
Line -16777216 false 286 126 294 128
Line -16777216 false 193 284 206 285

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
