turtles-own [

  ;; these variables reflect selection and reinforcement
  behavior1               ;; counts all moves to black patches from any patch
  behavior2               ;; tcounts all moves to white patches from any patch
  reinforcement1          ;; tracks all reinforcement for moves to black patches
  reinforcement2          ;; tracks all reinforcement for moves to white patches


  reinforcement-ratio     ;; this represents reinforcement1/(reinforcement1 + reinforcement2)
  behavior-ratio          ;; this represents behavior1/(behavior1 + behavior2)

  interval1-check         ;; temporary value for use with the random interval schedule
  interval2-check
  int-counter1             ;; counts intervals in a session for behavior1
  int-counter2             ;; counts intervals in a session for behavior2
  set-counter             ;; identifies end of set
  session                 ;; keeps track of number of
]

to setup
  clear-all
  setup-turtles
  reset-ticks
end

to setup-turtles
  ;; creates an adjustable number of turtles to engage in behavior1 or behavior2

  create-turtles 1

  ask turtles [
    setxy random-xcor random-ycor   ;;each turtle starts on a random patch
    set shape "bird"
    set size 4

;; set initial parameters
    set behavior1 1
    set reinforcement1 1
    set behavior2 1
    set reinforcement2 1
    set reinforcement-ratio reinforcement1 / (reinforcement1 + reinforcement2)
    set behavior-ratio behavior1 / (behavior1 + behavior2)
    set interval1-check (2 * random interval1) + 1
    set interval2-check (2 * random interval2) + 1
    set int-counter1 1
    set int-counter2 1
]

end

to go

  clear-drawing

  ask turtles [
    if session >= sessions [set session 0]
    if set-counter = 0 [
      set interval1-check (2 * random interval1) + 1
      set interval2-check (2 * random interval2) + 1
    ]

    ifelse random-float 1 < reinforcement-ratio
        [
          behave1
          if interval1-check <= int-counter1
          [
            reinforce1
            set interval1-check (2 * random interval1) + 1
           ]
        ]

        [
          behave2
          if interval2-check <= int-counter2
          [reinforce2
          set interval2-check (2 * random interval2) + 1
        ]
        ]
    ]

  ask turtles [
    set behavior-ratio behavior1 / (behavior1 + behavior2)
    set reinforcement-ratio (reinforcement1) / (reinforcement1 + reinforcement2)
    set int-counter1 int-counter1 + 1
    set int-counter2 int-counter2 + 1
  ]

    tick

        ;; criteria for ending session in Herrnstein (1961)

  ask turtles [
    if set-counter = session-length [

      ;; Command Center Display
      type "end of session " print session + 1
      type "interval B1 " type interval1 type " interval B2 " print interval2
      type "session R1/(R1+R2) " print (reinforcement1 - 1) / (reinforcement1 - 1 + reinforcement2 - 1)
      type "session B1/(B1+B2) " print (behavior1 - 1) / (behavior1 - 1 + behavior2 - 1)
      type "Total Behavior1 " type behavior1 - 1 type " Total Behavior2 "
      type behavior2 - 1 type " Total Reinforcement1 "
      type reinforcement1 - 1 type " Total Reinforcement2 "
      print reinforcement2 - 1
      type "Ticks at end of session " print ticks
      print " "

      ;; reset settings
      set set-counter 0
      set session session + 1
      set behavior1 1
      set behavior2 1
      set reinforcement1 1
      set reinforcement2 1
      set reinforcement-ratio 0.5
      set int-counter1 1
      set int-counter2 1
      ]
    ]

  if [session] of turtle 0 = sessions [stop]

end

to behave1
;; executes behavior1 and updates settings for behavior1 and b1set
  pu
  set color orange
  rt random 360
  fd random 20
  pd
  repeat 4 [
    fd 4
    rt 90
   ]
  set behavior1 behavior1 + 1

end

to behave2
;; executes behavior2 and updates settings for behavior2 and b2set
  pu
  set color violet
  rt random 360
  fd random 20
  pd
   repeat 9 [
      fd 4
      left 40
      ]
    set behavior2 behavior2 + 1

end

to reinforce1

    if not extinction1? [
      set reinforcement1 reinforcement1 + 1
      set set-counter set-counter + 1
      set int-counter1 1
      let n 4
      loop [
        set n n - 0.25
        repeat 4 [
          fd n
          rt 90
        ]
        if n = 0.25 [stop]
      ]
    ]

end

to reinforce2

    if not extinction2? [
      set reinforcement2 reinforcement2 + 1
      set set-counter set-counter + 1
      set int-counter2 1
      pd
      let n 4
      loop [
        set n n - 0.25
        repeat 9 [
          fd n
          left 40
        ]
        if n = 0.25 [stop]
      ]
    ]

end
@#$#@#$#@
GRAPHICS-WINDOW
5
355
253
604
-1
-1
3.7
1
10
1
1
1
0
1
1
1
-32
32
-32
32
0
0
1
ticks
30.0

BUTTON
25
250
110
295
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
145
250
230
295
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
280
355
715
605
Actual and Predicted Behavior
time
frequency
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"B1" 1.0 0 -16777216 true "" "plot [ behavior1 ]  of turtle 0"
"PB1" 1.0 2 -2674135 true "" "plot [(behavior1 + behavior2) * (reinforcement1 / (reinforcement1 + reinforcement2))]  of turtle 0"
"B2" 1.0 0 -10899396 true "" "plot [behavior2 ] of turtle 0"
"PB2" 1.0 2 -13345367 true "" "plot [ (behavior1 + behavior2) * (reinforcement2 / (reinforcement1 + reinforcement2))] of turtle 0"

MONITOR
585
220
650
265
B1
[behavior1] of turtle 0
2
1
11

MONITOR
650
220
715
265
B2
[behavior2] of turtle 0
2
1
11

MONITOR
585
265
715
310
B1/(B1+B2))
[behavior-ratio] of turtle 0
2
1
11

MONITOR
585
135
715
180
R1/(R1+R2)
[reinforcement-ratio] of turtle 0
2
1
11

SLIDER
15
120
130
153
interval1
interval1
1
1000
135.0
1
1
NIL
HORIZONTAL

SLIDER
135
120
250
153
interval2
interval2
1
1000
135.0
1
1
NIL
HORIZONTAL

MONITOR
585
90
650
135
R1
[reinforcement1] of turtle 0
2
1
11

MONITOR
650
90
715
135
R2
[reinforcement2] of turtle 0
2
1
11

TEXTBOX
60
100
210
118
Set schedules of reinforcement
11
0.0
1

TEXTBOX
45
10
235
51
Choose number of sessions and session length (# reinforcements)
11
0.0
1

TEXTBOX
55
210
235
236
Select setup before the first session; then select go to run each session
11
0.0
1

PLOT
280
50
560
325
Proportion Selections  (Session)
R1(R1+R2)
(B1/(B1+B2)
0.0
1.0
0.0
1.0
true
false
"" ""
PENS
"A0" 1.0 0 -2674135 true "" "if [set-counter] of turtle 0 = (session-length) [plotxy [(reinforcement1 - 1) / (reinforcement1 - 1 + reinforcement2 - 1)] of turtle 0 [(behavior1 - 1) / (behavior1 - 1 + behavior2 - 1)] of turtle 0]"

SLIDER
5
45
130
78
sessions
sessions
0
100
2.0
1
1
NIL
HORIZONTAL

SWITCH
15
160
130
193
Extinction1?
Extinction1?
1
1
-1000

SWITCH
135
160
250
193
Extinction2?
Extinction2?
1
1
-1000

SLIDER
135
45
260
78
session-length
session-length
0
1000
60.0
10
1
NIL
HORIZONTAL

TEXTBOX
30
320
240
350
Set ticks slower for best viewing; \nturn view updates off for quickest results
11
0.0
1

TEXTBOX
280
16
580
51
Plots one data point per session. Set interval1 and interval2 to different values from one another to get best results 
11
0.0
1

TEXTBOX
390
335
710
353
Plots actual and predicted behavior during and across sessions
11
0.0
1

TEXTBOX
585
190
760
216
Tracks behavior during\n each session
11
0.0
1

TEXTBOX
585
60
730
86
Tracks reinforcement during\n each session
11
0.0
1

TEXTBOX
585
15
735
71
To see end of session results, \nsee Command Center.
11
25.0
1

@#$#@#$#@
## WHAT IS IT?

This model simulates choice allocation between two behaviors using an early formulation of the Matching Law ([Herrnstein, 1961](link.https://www.ncbi.nlm.nih.gov/pmc/articles/PMC1404074/pdf/jeabehav00196-0083.pdf)).  According to this formulation, the ratio of engagement in a specific behavior as opposed to all other behavior is equal to the ratio of reinforcement for engaging in that behavior as opposed to reinforcement for all other behaviors.

This formula is expressed for two behaviors as:

>B1/(B1 + B2) = R1/(R1 + R2)

>where

>B1 = behavior 1
>B2 = behavior 2
>R1 = reinforcement received for behavior 1
>R2 = reinforcement received for behavior 2

This model uses the equation above to simulate behavior allocation across different schedules of reinforcement when two behaviors are available. The model can be used to explore choice behavior in a limited context, but is designed to simulate early experiments on the Matching Law.   


## HERRNSTEIN (1961) AND THE VARIABLE INTERVAL SCHEDULE OF REINFORCEMENT

In his study, Herrnstein recorded the pecking behavior of three pigeons across different schedules of reinforcement. Each pigeon was trained to peck two keys. During sessions, pecking a key after a variable amount of time passed resulted in reinforcement (access to food). **Pecking on a key before reinforcement was available resulted in no programmed changes.  When the time interval passed and reinforcement was available, then the first peck to that key resulted in access to food.**

**Each key was independent from the other.** That is, each key had its own time interval in effect, and pecks to the other key or reinforcement delivered due to a peck to the other key had no effect on the first key.  **When a time interval was over, the "clock" essentially stopped for that key until the key was pecked, at which time reinforcement was delivered and a new interval started.**

**Within a session, the intervals were variable, but were programmed to average out to a specific interval (e.g., 3 minutes). The keys could be set to the same average interval, or different average schedules.** That is, both keys could be set to 3-minute intervals (on average), or one key could be set to a 3-minute interval and the other to a 1.5-minute interval (again, on average), and so one.

This arrangement is known as a **Variable-interval schedule.**  It has several advantages for studying choice behavior - specifically, it results in steady, relatively rapid responding and is sensitive to programmed schedule changes.

>In summary, a variable interval schedule is a schedule in which a reinforcer is delivered for the **FIRST RESPONSE AFTER** a time interval has passed. This time interval is programmed to **vary across an average length**. In Herrnstein's experiement, each key the pigeons pecked had its own variable interval schedule.  In our model, each behavior has its own variable interval schedule*.

>*Technically, our model uses a random interval schedule, because rather than programming each interval in advance, we are using a random number generator. Given the nature or random number generators, this means our schedule may not precisely match the average, but with enough opportunities it should be very close.

After training, Herrnstein ran each pigeon through a series of sessions with a specified schedule of reinforcement for each key.  Each session ended when a total of 60 reinforcements had been delivered (about an hour and a half, on average).  Sessions of the same schedules were conducted until the pigeon responded consistently. At that point, Herrnstein took the mean of the last five sessions and plotted the percentage of reinforcements for responding to the first key on the x-asis and the percentage of responses to the first key along the y-axis.

Based upon his findings, Herrnstein developed the formula above to describe the behavior of the pigeons in his experiment. Subsequent experiments have extended these findings across different animals (including humans; see Borrero & Vollmer, 2002; Reed & Martens, 2008; Romanowich, Bourret, & Vollmer, 2007 for examples) and have refined this initial equation (see Baum, 1974, 1979 for examples). This original equation still describes behavior allocation well enough to serve as the starting point for our model.

## HOW IT WORKS

**Agent Properties.**  An agent is randomly seeded on the screen and given the  following properties:

  * BEHAVIOR1 - a running tally of the number of times the agent has drawn a square

  * BEHAVIOR2 - a running tally of the number of times the agent has drawn a circle

  * REINFORCEMENT1 - a running tally of the number of reinforcements that have followed BEHAVIOR1

  * REINFORCEMENT2 - a running tally of the number of reinforcements that have followed BEHAVIOR2

  * REINFORCEMENT-RATIO - REINFORCEMENT1 / (REINFORCEMENT1 + REINFORCEMENT2).

  * BEHAVIOR-RATIO - BEHAVIOR1 / (BEHAVIOR1 + BEHAVIOR2)

  * INTERVAL1-CHECK and INTERVAL2-CHECK - these function as the interval lengths for reinforcement delivery for the respective behaviors.  They are set at (2 * Random Interval) + 1, where "Interval" is the slider setting for Interval1 or Interval2.

  * INT-COUNTER1 and INT-COUNTER2 - these variables track the number of ticks that pass without reinforcement being delivered for a specific behavior.

  * SET-COUNTER - tracks number of reinforcements delivered within a session

  * SESSION-COUNTER - tracks number of sessions completed
  

**Initial Settings.** At the beginning of the simulation, behavior and reinforcement properties are all set to 1.  If the simulation started with both reinforcement properties set to 0, then the first reinforcement delivery would force the agent to select only the behavior that had been reinforced first for the entire session.  Conceptually, these settings are equivalent to one "forced exposure" to each behavior each followed by reinforcement. These same settings are used to intiate each session. 

**Sessions.** Each session lasts until the number of reinforcements set by the SESSION-LENGTH slider (plus 2 to acount for the initial settings) is reached. When a session ends, the simulation continues into the next session until the number of sessions indicated on the SESSIONS slider is reached. At this point, new interval values may be assigned and the simulation can continue, or the simulation may be reset using the SETUP button.

**Behaving.** Each tick, the agent must engage in one of the behaviors. Which of the two behaviors selected is determined by comparing a random number from 0 to just less than 1 to the ratio: REINFORCEMENT1 / (REINFORCEMENT1 + REINFORCEMENT2).  If the random number is less than the ratio, then the agent engages in BEHAVIOR1 and an orange square is drawn on the screen.  Otherwise, it engages in BEHAVIOR2 and a violet circle is drawn instead.

**Reinforcement.**  At the beginning of the simulation and each session, a random interval length is determined for each behavior based on the INTERVAL1 and INTERVAL2 sliders. This interval length may be as short as 1 tick to as long as nearly twice as many ticks as indicated by the slider.  When an agent engages in a behavior, the interval length is checked as well as how many ticks have passed since that behavior was reinforced. If as many ticks or more have passed as the interval length, reinforcement is delivered and the interval is reset.  Otherwise, a counter keeps track of the number of intervals and no reinforcement is delivered.  Reinforcement consists of increasing the reinforcement value by 1, and is represented visually by "filling in" the shape that was reinforced.  If an **Extincition?** switch has been turned on, no reinforcement is delivered for the corresponding behavior regardless of the schedule. 
 
## HOW TO USE IT

**Sessions.**  This slider determines how many sessions are run at a time.  If you select 3, for example, the simulation will keep running until 3 sessions have been plotted.  Useful if you want to see how much variation there is from one session to another under the same schedule of reinforcement.

**Session-length.**  This slider determines the length of the session, _based on the total number of reinforcements delivered_.  In Herrnstein (1961), each session lasted until a total of 60 reinforcers had been delivered.

**Schedules of Reinforcement.** 

  * Adjust the INTERVAL1 slider to set the _minimum average_ number of ticks between reinforcement being available for engaging in BEHAVIOR1.

  * Adjust the INTERVAL2 slider to set the _minimum average_ number of ticks between reinforcement being available for engaging in BEHAVIOR2.

  * Set EXTINCTION1? to ON if you want to make sure reinforcement is **never** delivered within session for BEHAVIOR1. Otherwise, leave this switch **OFF**.

  * Set EXTINCTION2? to ON if you want to make sure reinforcement is **never** delivered within session for BEHAVIOR2. Otherwise, leave this switch **OFF**.

**Setup.**  Click set up to reset the simulation. If desired, also select **Clear** in the Command Center to erase the Command Center.

**Go.**  Press go to start the simulation after setup, and to continue running more sessions when the simulation stops.

## THINGS TO NOTICE

**Actual and Predicted Behavior.** As your simulations runs, this plot shows you the frequency of BEHAVIOR1 and BEHAVIOR2 (solid lines). It also shows you the predicted frequency (red and blue dots) based upon the equation:

>B1 = (B1 + B2) * (R1 / (R1 + R2))

For a description of the terms, see the original equation above.  Note that this equation is simply removing the denominator from the left side of the equation over to the right side of the equation.

**Proportion Selection.** This plot updates after each session (if it is set to produce lines rather than points, at least 2 sessions need to be run before you see anything).  If you keep the interval settings equal, you should expect to see a cluster of dots or lines in the middle of the graph.  As you change the interval schedules so that INTERVAL1 is lower than INTERVAL2, you will see the dots or lines move towards the origin.  As INTERVAL1 becomes greater than INTERVAL2, you will see the dots/lines moves towards the upper right of the graph.

To the extent these dots or lines fall along an imaginary line from (0,0) to (1,1), Herrnstein's formula holds true.  

**The Monitors.**  If you have the simulation running at normal speed, the monitors will change very quickly and reset to the start values before you know it.  No worries, you can see the results of each session in the Command Center.  If the schedule of reinforcement is rather lean or you slow the simulation down, then the monitors can help you track what is going on.

**The Command Center.**  The command center gives you a print out of the variables after each session.

## THINGS TO TRY

**Running the same schedule over multiple sessions.** The results should be fairly similar, but not identical.  For example, if INTERVAL1 and INTERVAL2 are set to the same values, you may find slightly more responses to BEHAVIOR1 in one session, and the opposite pattern in the next.  If the Interval settings are very different, though, you should expect to see the interval with the lowest setting reliably generate the most responding.

**Keep INTERVAL1 and INTERVAL2 equal, and start with low settings and gradually move to higher and higher settings across sessions.**  Observe what this does to the frequency and patterns of responding across sessions.

**Experiment with Extinction.** Try turning extinction on for one of the interval settings.  What happens?  Note that this simulation is not designed to simulate actual extinction - the agent will continue drawing shapes until the the simulation is shut down or the world ends, whichever comes first, with or without reinforcement.

**Set different values for INTERVAL1 and INTERVAL2 across sessions.** Watch the Proportion Selection plot and see if a line forms at a 45 degree angle (more or less) out from the origin.

**Set SESSION-LENGTH high and adjust the schedules within a session.**  This model isn't designed to evaluate schedule changes within a session, but it doesn't mean you can experiment with it.

## SIMULATING FIGURE 1 OF HERRNSTEIN (1961)

In order to simulate Herrnstein (1961), follow the instructions below.

  1. Set the SESSIONS slider to 1.
  2. Set the SESSION-LENGTH slider to 60.
  3. Set the INTERVAL1 slider to 405.
  4. Set the INTERVAL2 slider to 81.
  5. Make sure the EXTINCTION? switches are off.
  6. Click SETUP.
  7. Click GO.
  8. Wait untl the simulation stops.
  9. Click GO again.  Wait until the simulation stops.
  10. Set both INTERVAL sliders to 135.
  11. Click GO. Wait until the simulation stops.
  12. Set INTERVAL1 to 101 and INTERVAL2 to 202.
  13. Click GO.  Wait until the simulation stops.
  14. Set INTERVAL1 to 81 and INTERVAL2 to 405.
  15. Click GO.  Wait until the simulation stops.
  16. Set INtERVAL1 to 67.
  17. Set EXTINCTION2? to ON.
  18. Click GO.  Wait until the simulation stops.

At this point, you have simulated all of the data points for the pigeon #055.  You should see a series of dots in the PROPORTION SELECTIONS plot that should cluster around an imaginary line from (0,0) to (1,1).

You may continue without hitting SETUP to add the remaining pigeons data to the plot, or hit SETUP to clear the plot and continue with the next pigeon.

If you keep going without hitting SETUP, change the color in the PROPORTION SELECTIONS plot to orange - this will help you differentiate the data points simulation pigeon #055 from the next pigeon.

  1. Keep all of the sliders as they were at the end of the last step.
  2. Click GO.  Wait for the simulation to run.
  3. Set INTERVAL1 to 81 and INTERVAL2 to 405.
  4. Set EXTINCTION2? to OFF.
  5. Click GO.  Wait.
  6. Set INTERVAL1 to 135 and INTERVAL2 to 135.
  7. Click GO. Wait.
  8. Set INTERCAL1 to 202 and INTERVAL2 to 101.
  9. Click GO.  Wait.
  10. Set INTERvAL1 to 405 and INTERVAL2 to 81.
  11. Click GO. Wait.
  12. Click GO again.  Wait.

You have now simulated pigeon #231's data.  Again, you may click on SETUP to clear the plots and start fresh for the next pigeon, or simply move on to the last pigeon.  If you move on without hitting SETUP, change the color of the PROPORTION SELECTIONS PLOT again to something like blue or green.

  1. Keep everything as it was at the end of the last step.
  2. Set INTERVAL1 to 135 and INTERVAL2 to 135.
  2. Click GO. Wait.
  4. Set INTERVAL1 to 101 and INTERVAL2 to 202.
  5. Click GO. Wait.
  6. Compare your results to Figure 1.

If it is hard to see, change the setting from "POINT" to "LINE" in the PROPORTION SELECTIONS plot. If you would like, copy the information in the Command Center and save it into a word document.  It contains all the information you need to make a figure of your own using favorite figure-generating software.  Exporting the plot to Excel actually exports ALL of the data points in a session, so this method is not recommended.


## EXTENDING THE MODEL

This model lends itselt to a number of extensions.  A few are listed below.

**Pre-Session History.** In the current model, pre-session history is reset to 1 for each behavior and reinforcement value.  This essentially gives the agent a minimal behavior history.  Research has shown that the history of reinforcement for a behavior does effect response allocation (Karsina, Thompson, & Rodriguez, 2011).  Future models could investigate allowing pres-session behavior and reinforcement settings to be manipulated by the user and allowing behavior histories to carry over from one session to the next.

**Different Schedules of Reinforcement.** This model evaluates a simulation of the random-interval schedule.  Extensions could investigate how response allocations varies across different schedules of reinforcement (e.g., ratio schedules, fixed schedules, etc).  

**Strategies.** The current model relies upon the ratios of reinforcement to determine behavior. For humans especially, strategies or rules may effect responding as well.  Future models could examine how rules might work against, or with, the Matching Law.

**More Current Versions of the Matching Law.** This model examines the first formulation of what is now known as the Matching Law.  As of this writing, this equation is well over 50 years old.  As noted earlier, researchers have studied and refined this equation over the years.  Extensions of this model could evaluate these equations.

## NETLOGO FEATURES

This model uses the LOOP command to "draw in" the individual shapes.  As the length of each side of a drawn shape was 4, the following loop was used to draw in the square:

```
let n 4
      loop [
        set n n - 0.25
        repeat 4 [
          fd n
          rt 90
        ]
        if n = 0.25 [stop]
      ]
```

## RELATED MODELS

This is the first in what is intended to be a series of models investigating behavioral principles.  This section will be updated when subsequent models are published.

## CREDITS AND REFERENCES

This model can be found on the web at https://app.box.com/s/b2awrje7tly279axn0zstjf0srw67of7

Baum, W. M. (1974). On two types of deviation from the matching law: bias and undermatching. _Journal of the Experimental Analysis of Behavior, 22,_ 231-242.

Baum, W. M. (1979). Matching, undermatching, and overmatching in studies of choice. _Journal of the Experimental Analysis of Behavior, 32,_ 269-281. 

Borrero, J. C., & Vollmer, T. R. (2002). An application of the matching law to severe problem behavior. _Journal of Applied Behavior Analysis, 35,_ 13-27.

>Herrnstien, R. J. (1961). Relative and absolute strength of response as a function of frequency of reinforcement.  _Journal of the Experimental Analysis of Behavior, 4,_ 267-272.

>Article available at https://www.ncbi.nlm.nih.gov/pmc/articles/PMC1404074/pdf/jeabehav00196-0083.pdf

Karsina, A., Thompson, R. H., & Rodriguez, N. M. (2011). Effects of a history of differential reinforcement on preference for choice. _Journal of the Experimental Analysis of Behavior, 95(2),_ 189-202. 

Reed, D. D. & Martens, B. K. (2008). Sensitivity and bias under conditions of equal and unequal academic task difficulty. _Journal of Applied Behavior Analysis, 41,_ 39-52.

Romanowich, P., Bourret, J., & Vollmer, T. R. (2007). Further analysis of the matching law to describe two- and three-point shot allocation by professional basketball players. _Journal of Applied Behavior Analysis, 40,_ 311-3115.

## COPYRIGHT AND LICENSE

Copyright 2018 Allen Karsina

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License. To view a copy of the license, visit https://creativecommons.org/licenses/by-nc-sa/3.0.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bird
false
0
Polygon -7500403 true true 135 165 90 270 120 300 180 300 210 270 165 165
Rectangle -7500403 true true 120 105 180 237
Polygon -7500403 true true 135 105 120 75 105 45 121 6 167 8 207 25 257 46 180 75 165 105
Circle -16777216 true false 128 21 42
Polygon -7500403 true true 163 116 194 92 212 86 230 86 250 90 265 98 279 111 290 126 296 143 298 158 298 166 296 183 286 204 272 219 259 227 235 240 241 223 250 207 251 192 245 180 232 168 216 162 200 162 186 166 175 173 171 180
Polygon -7500403 true true 137 116 106 92 88 86 70 86 50 90 35 98 21 111 10 126 4 143 2 158 2 166 4 183 14 204 28 219 41 227 65 240 59 223 50 207 49 192 55 180 68 168 84 162 100 162 114 166 125 173 129 180

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
