breed [ keepers keeper ]
breed [ takers taker ]

keepers-own [ 
  dive ;;how fast he dives (the taker doesn't move)
  choices 
  choice 
  results
  result
  strategies
  best-strategy 
  tendency
  cheat-sheet1
  cheat-sheet2
  ]

takers-own [ choices choice results best-strategy strategies tendency cheat-sheet1 cheat-sheet2 ] ;;same stuff

turtles-own [ power ] ;;how fast the ball's moving

globals [ 
  ;;for statistics
  goals 
  misses 
  saves 
  
  ;;for functions
  over? ;;true when we know the result of the kick 
  gk ;;the keeper whose turn it is 
  tk ;;the taker whose turn it is
  ball ;;the ball turtle
  
  ;;for plotting
  allresults
  gk-allchoices 
  tk-allchoices 
  gk-tendencies ;;list of each player's tendencies noted after his turn
  tk-tendencies 
  ]


;SETUP FUNCTIONS

to setup
  clear-all-plots
  reset-ticks
  setup-plots
  clr
  ask patches with [ pzcor = -4 and pycor = 1 ] [ 
    if pcolor != green [ line-field set-goal ] 
    ] ;;set up field only if it isn't already set
  setup-turtles
end

to clr
  ask turtles with [ color != white ] [ die ] ;;clear keepers, takers, and the ball, but not the goal
  set over? false
  set goals 0
  set misses 0
  set saves 0
  set gk-allchoices []
  set tk-tendencies []
  set gk-tendencies []
  set tk-allchoices []
  set allresults []
end

to line-field
  ask patches with [ pzcor = -4 ] [ set pcolor green ]
  ask patches with [ pycor = 36 or pycor = -18 or (pycor = 18 and abs pxcor <= 30) or (abs pxcor = 30 and 18 <= pycor and pycor <= 36) and pzcor = -4 ] [ set pcolor white ]
  ask patches with [ pycor = 0 and pxcor = 0 and pzcor = -4 ] [ set pcolor white ]
  ask patches with [ precision (distance patch 0 0 0) 0 = 30 and pycor <= -18 and pzcor = -4 ] [ set pcolor white ]
end

to set-goal
  ask patches with [ (pycor = 38  and abs pxcor <= 12) or (abs pxcor = 12 and 38 >= pycor and pycor >= 36) and pzcor > -4 and pzcor <= 4 ] [ sprout 1 [ set shape "box" set color white set size .5 ] ]
  ask patches with [ pzcor = 4 and pycor < 38 and pycor >= 36 and abs pxcor <= 12 ] [ sprout 1 [ set shape "box" set color white set size .5 ] ]
end

to setup-turtles
  crt 1 [ ;;create ball
    set size .75 set color orange set shape "circle" setxyz 0 0 -3.125 set ball self 
    ]
  foreach n-values num-takers [ ? * 2 ] [ ;;create num-takers penalty takers
    create-takers 1 [ set size 6 set color red set shape "person" setxyz 36 (35 - ?) -1 set heading 0 ]
    ]
  foreach n-values (num-takers + 1) [ ? * 2 ] [ ;;create num-takers + 1 goalkeepers
    create-keepers 1 [ set size 6 set color yellow set shape "person" setxyz -36 (35 - ?) -1 set heading 0 ]
    ]
  if not Manual [
    ask (turtle-set keepers takers) [ 
      set choices n-values (memory-size * 2) [ one-of (list -1 1) ] ;;randomize previous choices
      set results n-values (memory-size * 2) [ one-of (list 0 0 1 1 1 1 1 1 1 1) ] ;;randomize previous results to success rate of 80%
      learning-setup ;;setup strategies
    ]
  ]
  get-ready
end

to learning-setup
  set strategies n-values num-strategies [random-strategy]
  set best-strategy first strategies
end

to get-ready
  ask (turtle-set keepers takers) [ fd 2 ] ;;dequeue
  ask keepers with [ patch-here = patch -36 37 -1 ] [ ;;(head of the keepers queue)
    set gk self move-to patch 0 36 -1 
    ]
  ask takers with [ patch-here = patch 36 37 -1 ] [ ;;(head of the takers queue)
    set tk self move-to patch -6 -10 -1 
    ]
  if not Manual [
    ask (turtle-set gk tk) [ scout ] ;;obtain scouting data
  ]
  ask gk [ save-decision ] ;;both players decide before shot
  ask tk [ shot-decision ] 
end


;STRATEGY FUNCTIONS
; (Adapted from El Farol Bar)

to-report random-strategy
  report n-values (memory-size + 1) [ 1.0 - random-float 2.0 ]
end

to-report predict [strategy subhistory]
  report first strategy + sum (map [?1 * ?2] butfirst strategy subhistory)
end

to update-strategies [ sheet1 sheet2 ]
  let best-score (memory-size ^ 3) + 1
  foreach strategies [
    let score 0
    let kick 1
    repeat memory-size [
      let pred predict ? sublist sheet1 kick (kick + memory-size)
      set choice pred / (abs pred)
      set score score + abs (item (kick - 1) sheet2 - choice)
      set kick kick + 1
    ]
    if (score <= best-score) [
      set best-score score
      set best-strategy ?
    ]
  ]
end


;DECISION FUNCTIONS

to scout
  ifelse breed = keepers 
  [ set cheat-sheet1 translate [ choices ] of tk [ results ] of tk set cheat-sheet2 [ choices ] of tk ] 
  [ set cheat-sheet1 translate [ choices ] of gk [ results ] of gk set cheat-sheet2 [ choices ] of gk ]
end

to-report translate [ l1 l2 ]
  report ( map [ ?1 * ?2 ] l1 l2 )
end

to save-decision
  ifelse not Manual 
  [
    update-strategies cheat-sheet1 cheat-sheet2
    let raw-choice (predict best-strategy sublist cheat-sheet1 0 memory-size) + .000001 ;;to avoid division by zero
    ifelse students = "Goalkeepers"
      [ set choice (raw-choice / abs raw-choice) ] 
      [ ifelse random 100 < teach-nat-tendency [ set choice 1 ] [ set choice -1 ] ] ;;positive = 1 = natural, negative = -1 = non-natural
    set choices fput choice butlast choices ;;choices are limited to memory-size * 2
    set gk-allchoices fput choice gk-allchoices ;;allchoices are unlimited
    set dive (random 20) * .0005 ;;how far he stretches to get the ball is random, since direction of ball is random except left or right
    ifelse choice = 1 ;;1 is natural
      [ set heading -90 ] 
      [ set heading 90 ]
  ]
  [
    set dive (random 20) * .0005
    ifelse random 100 < gk-tendency [ set heading -90 set choice 1 ] [ set heading 90 set choice -1 ]
  ]
end

to shot-decision
  ifelse not Manual 
  [
    let raw-choice (sum cheat-sheet1) + one-of (list .000001 (-1 * .000001))
    ifelse students = "Penalty Takers"
      [ set choice (raw-choice / abs raw-choice) ] 
      [ ifelse random 100 < teach-nat-tendency [ set choice 1 ] [ set choice -1 ] ]
    set choices fput choice butlast choices
    set tk-allchoices fput choice tk-allchoices
    ask ball [
      ifelse [ choice ] of myself = 1
        [ set heading random-float -1 * (atan 12.2 36) set pitch random-float (atan 8.1 36) set power .04 ]
        [ set heading random-float (atan 12.55 36) set pitch random-float (atan 8.3 36) set power .03 ]
    ]
  ]
  [
    ask ball [
      ifelse random 100 < tk-tendency
        [ set heading random-float -1 * (atan 12.2 36) set pitch random-float (atan 8.1 36) set power natural-power ask myself [ set choice 1 ] ]
        [ set heading random-float (atan 12.55 36) set pitch random-float (atan 8.3 36) set power non-natural-power ask myself [ set choice -1 ] ]
    ]
  ]
end


;GO FUNCTIONS

to go
  if over? [ 
;     if ticks mod (num-takers + 1) = 0 [ 
;        ask (turtle-set keepers takers) [
;          let Z ind-sequence-Z-score choices count-runs choices 
;          if (abs Z > 2) [ 
;            set rejections rejections + 1 
;          ]
;        ]
;      ]
    if not Manual [
      ask (turtle-set gk tk) [ ;;update tendencies
        set tendency length filter [ ? = 1 ] sublist choices 0 memory-size / memory-size
        ifelse breed = keepers [ set gk-tendencies fput tendency gk-tendencies ] [ set tk-tendencies fput tendency tk-tendencies ] ]
    ]
    move-queue 
    get-ready 
    ask ball [ setxyz 0 0 -3.125 ] 
    set over? false 
    if not Manual [ tick ]
    ]
  ;;if not over, proceed:
  ask ball [ fd power ]
  ask gk [ 
    if [ distance patch 0 0 -10 ] of ball >= 26 and choice * [ choice ] of tk = 1 [ 
      face ball set dive .01 
      ] 
    ] ;;the keeper stretches for the ball if he is near enough
  ask gk [ fd dive ]
  save?
  score?
end

to move-queue
  ask min-one-of keepers [ distance patch 12 36 -4 ] [ move-to patch -36 (35 - num-takers * 2) -1 set heading 0 set pitch 0 ]
  ask min-one-of takers [ distance patch 0 0 0 ] [ move-to patch 36 (37 - num-takers * 2) -1 set heading 0 ]
end

to save?
  ask gk [ 
    if distance ball <= 2 and (abs ([ heading ] of ball - 180)) > ((atan -12 36) - 180) and [ pitch ] of ball < (atan 8 36) [ 
      ;;if the ball is between the posts and the distance between it and the keeper is less than or equal to 2
      set misses misses + 1 
      set saves saves + 1 
      set over? true 
      set allresults fput 0 allresults
      if not Manual [
        set results fput 0 butlast results
        ask tk [ set results fput 0 butlast results ]
      ]
      ask ball [
        set heading 270 - heading fd 1 ;;make sure the ball is parried away
      ]
    ]
  ] 
end

to score?
  ask ball [ if [ pycor ] of patch-here > 36 and (abs (heading - 180) > (atan -12 36) - 180) and pitch < (atan 8 36) [ 
      ;;if the ball passes the goal-line between the posts
      set goals goals + 1 
      set over? true 
      if not Manual [
        ask (turtle-set gk tk) [ set results fput 1 butlast results ]
      ]
      set allresults fput 1 allresults 
      ] 
      ] 
  ask ball [ if [ pycor ] of patch-here > 36 and ((abs (heading - 180) <= (atan -12 36) - 180) or pitch >= (atan 8 36)) [ 
      ;;air-ball
      set misses misses + 1 
      set over? true
      if not Manual [
        ask (turtle-set gk tk) [ set results fput 0 butlast results ]
      ]
      set allresults fput 0 allresults
      ] 
  ]
end


;;Non-functioning probability functions

;to-report ind-sequence-Z-score [ s r ] ;;reports Z-score of a sequence s with r runs
;  let tot length s
;  let lc 0
;  foreach s [ if ? = -1 [ set lc lc + 1 ] ]
;  let rc tot - lc
;  report (r - (2 * lc * rc / tot) - 1) / sqrt ( (2 * lc * rc * (2 * lc * rc - tot) ) / ((tot ^ 2) * (tot - 1)))
;end

;to-report count-runs [ s ]
;  let runs 0
;  let run? false
;  let prev first s
;  let cnt (length s) - 1
;  foreach (but-first s) [ set cnt cnt - 1
;                          if (run? = false and ? = prev) [ set run? true ]
;                          if (run? = true and (? != prev or cnt = 0)) [ set run? false set runs runs + 1 ]
;                          set prev ? ]
;  report runs
;end
@#$#@#$#@
GRAPHICS-WINDOW
0
0
245
108
38
38
1.0
1
10
1
1
1
0
1
1
1
-38
38
-38
38
-4
4
1
0
1
ticks
30.0

BUTTON
41
174
198
236
GO
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
39
94
196
156
SETUP/CLEAR
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
376
101
449
146
Goals
goals
17
1
11

MONITOR
375
150
447
195
Misses
misses
17
1
11

MONITOR
376
199
447
244
Saves
saves
17
1
11

SLIDER
40
57
180
90
memory-size
memory-size
10
40
15
1
1
kicks
HORIZONTAL

SLIDER
39
12
154
45
num-takers
num-takers
1
35
20
1
1
NIL
HORIZONTAL

PLOT
39
439
798
559
Scoring rate (black), taker tendency (red), keeper tendency (yellow), 50% (blue)
kicks
%
1.0
10.0
0.0
100.0
true
false
"" ""
PENS
"rate" 1.0 0 -16777216 true "set-plot-pen-mode 0" "if ticks > num-takers [plot 100 * (length filter [ ? = 1 ] (sublist allresults 0 num-takers) / num-takers)]"
"nat-dive" 1.0 0 -592232 true "set-plot-pen-mode 1" "if ticks > (num-takers + 1) [plot 100 * (length filter [ ? = 1 ] (sublist gk-allchoices 0 (num-takers + 1)) / (num-takers + 1))]"
"nat-kick" 1.0 0 -2674135 true "set-plot-pen-mode 0" "if ticks > num-takers [plot 100 * (length filter [ ? = 1 ] (sublist tk-allchoices 0 num-takers) / num-takers)]"
"blue" 1.0 0 -13345367 true "set-plot-pen-mode 0" "plot 50"

MONITOR
207
201
355
246
Success rate (total)
goals / (goals + misses)
17
1
11

SLIDER
183
57
307
90
num-strategies
num-strategies
1
50
10
1
1
NIL
HORIZONTAL

MONITOR
206
148
358
193
Nat side tendency (Takers)
(length filter [ ? = 1 ] tk-allchoices / length tk-allchoices)
17
1
11

MONITOR
203
99
361
144
Nat side tendency (Keepers)
(length filter [ ? = 1 ] gk-allchoices / length gk-allchoices)
17
1
11

PLOT
423
307
797
427
Tendencies (Penalty Takers)
NIL
NIL
0.0
0.95
0.0
0.05
true
false
"set-plot-x-range 0 .95\nset-plot-y-range 0 35\nset-histogram-num-bars 20" ""
PENS
"default" 1.0 0 -955883 true "set-plot-pen-mode 1" "if ticks > 0 and ticks mod num-takers = 0 mod num-takers[ histogram tk-tendencies ]"

PLOT
38
308
413
428
Tendencies (Goalkeepers)
NIL
NIL
0.05
0.95
0.0
50.0
true
false
"set-plot-x-range 0 .95\nset-plot-y-range 0 35\nset-histogram-num-bars 20" ""
PENS
"default" 1.0 0 -817084 true "set-plot-pen-mode 1" "if ticks > 0 and ticks mod (num-takers + 1) = 0 mod (num-takers + 1) [ histogram gk-tendencies ]"

SWITCH
162
12
265
45
Manual
Manual
1
1
-1000

TEXTBOX
677
41
804
121
Mixed Strategy Play \nin Penalty Kicks\n\nBy Matt Hong\nJune 10, 2013
12
3.0
1

TEXTBOX
491
14
641
32
MANUAL SETTINGS:
11
0.0
1

SLIDER
490
37
662
70
gk-tendency
gk-tendency
0
100
100
1
1
%
HORIZONTAL

SLIDER
492
76
664
109
tk-tendency
tk-tendency
0
100
100
1
1
%
HORIZONTAL

SLIDER
490
114
662
147
natural-power
natural-power
0
.1
0.04
.01
1
NIL
HORIZONTAL

SLIDER
492
151
665
184
non-natural-power
non-natural-power
0
.1
0.03
.01
1
NIL
HORIZONTAL

TEXTBOX
488
193
768
245
McCormick School of Engineering, Evanston, IL\nElectrical Engineering and Computer Science 372-0\nProfessor Uri Wilensky\nTeaching Assistant Bryan Head
10
3.0
1

CHOOSER
276
10
440
55
students
students
"Goalkeepers" "Penalty Takers"
0

SLIDER
309
57
462
90
teach-nat-tendency
teach-nat-tendency
0
100
59
1
1
%
HORIZONTAL

MONITOR
41
255
229
300
GK natural success rate
1 - (length filter [ ? = 1 ] translate allresults gk-allchoices) / (length filter [ ? = 1 ] gk-allchoices)
17
1
11

MONITOR
235
255
413
300
GK non-natural success rate
1 - (length filter [ ? = -1 ] translate allresults gk-allchoices) / (length filter [ ? = -1 ] gk-allchoices)
17
1
11

MONITOR
607
255
796
300
Taker non-natural success rate
(length filter [ ? = -1 ] translate allresults tk-allchoices) / (length filter [ ? = -1 ] tk-allchoices)
17
1
11

MONITOR
423
255
598
300
Taker natural success rate
(length filter [ ? = 1 ] translate allresults tk-allchoices) / (length filter [ ? = 1 ] tk-allchoices)
17
1
11

@#$#@#$#@
## WHAT IS IT?

This is a model of penalty kicks in soccer. Being a zero-sum mixed-strategy game involving a finite number of players, it has a Nash equilibrium. The Nash equilibrium is a set of strategies chosen by each of the players which result in an optimal situation for all. For any player in equilibrium, deciding to change the proportion of any pure strategy used over another will result in having chosen a worse strategy than before. The agents in the model each try to employ different strategies in attempts to learn to play in that Nash equilibrium. By default, the Nash equilibrium exists at around [40%, 60%] for all players. The pure strategies involved are [L, R], non-natural or natural side. Note that the natural side for a right-footed player is his left and the keeper's right, indicated by R.

The analysis of this theory of minimax play in penalty kicks is put forth by Ignacio Palacios Huerta (2003).

## HOW IT WORKS

Goalkeepers learn adaptively. The algorithm used here is fully described in the Info Tab of the El Farol model in the models library. 

Penalty takers learn goal-oriented. One takes a cheat sheet with information about his opponent's choices when he failed, and exploits that knowledge by choosing the side on which the opponent let in the larger amount of goals.
 
The length of the cheat sheet, and the amount of data available to an agent to create his cheat sheets is given by MEMORY-SIZE.
At any moment, either goalkeepers are learning or penalty takers are learning. This is given by STUDENTS. Teachers, on the other hand, have a slider TEACH-NAT-TENDENCY, which will set the probability of the teachers choosing their natural side over their non-natural side. 

That's how the learning works, and each penalty kick itself is geared to replicate real-life data, so physically they work as they do in real life. Ball goes in, he scores!

## HOW TO USE IT

To use the model, set the NUM-TAKERS, MEMORY-SIZE, NUM-STRATEGIES, TEACH-NAT-TENDENCY, choose which breed to make learn, press SETUP, and then GO.

There many plots and monitors available to analyze the data. The monitor for scoring rates is aggregate, but the scoring rates on the plot is measured at each tick for the last NUM-TAKERS players. The plot and histograms show each breed's natural side tendencies, also measured for the last NUM-TAKERS players. The four monitors which report the isolated success rates according to footing can be used to compare results to the prediction of equal success rates among pure strategies.

## THINGS TO NOTICE

The 3D visual is awesome. 

## THINGS TO TRY

The manual settings exist to extend the option of further analysis. Set MANUAL switch to ON if you wish to use these settings. The powers indicate the power of the ball when kicked to either side. For example, it might be useful to know what the total success rate is when all players choose their natural side 50% of the time. 

Run the model with different settings for MEMORY-SIZE and NUM-STRATEGIES. What happens to the variability in the plots?

## EXTENDING THE MODEL

At the bottom of the code, there is a botched equation for calculating the Z-score of a sample list to know the probability of it being non-random. Try to get this right! There is a bit of code in the GO function as well to get you started on the implementation if you get the Z-score function right.

It is not too hard to change the learning algorithms for the players. Try adapting certain cognition codes from other models.

## NETLOGO FEATURES

This model does not run on ticks. A tick here represents a single penalty kick.
Lists are used to represent choices, results, and strategies.
n-values is useful for generating random lists.
Histograms provide an interesting visualization, but notice that the upper limit to each interval is open.

## RELATED MODELS

El Farol, Traffic Grid

## CREDITS AND REFERENCES

Palacios-Huerta, Ignacio (2003) http://www.palacios-huerta.com/docs/professionals.pdf
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 3D 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="false">
    <setup>set goals 0
set misses 0
set saves 0
reset-ticks
clear-plot
setup</setup>
    <go>go</go>
    <exitCondition>goals + misses = 2000</exitCondition>
    <metric>(length filter [ ? = 1 ] sublist tk-allchoices (length tk-allchoices - 100) length tk-allchoices) / 100</metric>
    <steppedValueSet variable="memory-size" first="2" step="1" last="50"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
